/*
 * Decompiled with CFR 0.152.
 */
package flexagon.fd.logging;

import com.sun.enterprise.server.logging.FormatterDelegate;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class FlexDeployGlassFishLogFormatter
extends UniformLogFormatter {
    private static String LINESEP = System.getProperty("line.separator");
    public static final ThreadLocal<Map<String, String>> FF_FORMATTER_VALS = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    SimpleFormatter _internalFormatter = new SimpleFormatter();

    public FlexDeployGlassFishLogFormatter(FormatterDelegate pFormatterDelegate) {
        super(pFormatterDelegate);
    }

    public FlexDeployGlassFishLogFormatter() {
    }

    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append(new Date(record.getMillis()));
        sb.append(" - ");
        sb.append(Thread.currentThread().getId());
        sb.append(" - ");
        sb.append(record.getLevel());
        sb.append(" - ");
        Map<String, String> contextValues = FF_FORMATTER_VALS.get();
        sb.append(contextValues.get("contextUser"));
        sb.append(" - ");
        sb.append(contextValues.get("internalSessionId"));
        sb.append(" - ");
        sb.append(contextValues.get("callContextId"));
        sb.append(" - ");
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName());
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(".");
            sb.append(record.getSourceMethodName());
        }
        String message = this._internalFormatter.formatMessage(record);
        sb.append(" - ");
        sb.append(message);
        sb.append(LINESEP);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

