if [ -r "$CATALINA_BASE/bin/setenvoverride.sh" ]; then
  . "$CATALINA_BASE/bin/setenvoverride.sh"
elif [ -r "$CATALINA_HOME/bin/setenvoverride.sh" ]; then
  . "$CATALINA_HOME/bin/setenvoverride.sh"
fi

# Get the current directory
CURRENT_DIRECTORY=`pwd`

# Go up a directory
cd $CATALINA_HOME/..

# Get that directory, which is where css is installed
CSS_HOME=`pwd`

cd $CURRENT_DIRECTORY

if [ "$CSS_APPLICATION_DIRECTORY" = "" ]; then
  CSS_APPLICATION_DIRECTORY="$CSS_HOME/application"
fi

if [ "$CSS_ARTIFACTS_DIRECTORY" = "" ]; then
  CSS_ARTIFACTS_DIRECTORY="$CSS_HOME/artifacts"
fi

# if no initial memory size, set to default
if [ "$CSS_INITIAL_MEMORY_SIZE" = "" ]; then
  CSS_INITIAL_MEMORY_SIZE=1024m
fi

# if no max memory size, set to default
if [ "$CSS_MAX_MEMORY_SIZE" = "" ]; then
  CSS_MAX_MEMORY_SIZE=4096m
fi

# if no ldap pool timeout, set to default of 5 minutes
if [ "$CSS_LDAP_POOL_TIMEOUT" = "" ]; then
  CSS_LDAP_POOL_TIMEOUT=300000
fi

if [ "$CSS_COOKIE_SECURE" = "0" ]
then
  sed -i 's|<secure>true</secure>|<secure>false</secure>|' "$CATALINA_BASE/webapps/css/WEB-INF/web.xml"
elif [ "$CSS_COOKIE_SECURE" = "1" ]
then
  sed -i 's|<secure>false</secure>|<secure>true</secure>|' "$CATALINA_BASE/webapps/css/WEB-INF/web.xml"
fi

# Using either --> <!-- or a space so that it won't add either multiple times, only perform the switch.
if [ "$CSS_HSTS" = "0" ]
then
  sed -i 's|<!-- Start HSTS Section-->|<!-- Start HSTS Section\.|' "$CATALINA_BASE/webapps/css/WEB-INF/web.xml"
  sed -i 's|<!-- End HSTS Section-->|  End HSTS Section-->|' "$CATALINA_BASE/webapps/css/WEB-INF/web.xml"
elif [ "$CSS_HSTS" = "1" ]
then
  sed -i 's|<!-- Start HSTS Section\.|<!-- Start HSTS Section-->|' "$CATALINA_BASE/webapps/css/WEB-INF/web.xml"
  sed -i 's|  End HSTS Section-->|<!-- End HSTS Section-->|' "$CATALINA_BASE/webapps/css/WEB-INF/web.xml"
fi

if [ "$ENABLE_OMIT_STACK_TRACE_FAST_THROW" = "1" ]
then
    OMIT_STACK_TRACE_FAST_THROW=""
else
    OMIT_STACK_TRACE_FAST_THROW="-XX:-OmitStackTraceInFastThrow"
fi

#If you experience issues with the following line on your linux distribution, override JAVA_HOME in setenvoverride.sh
[ -z "$JAVA_HOME" ] && JAVA_HOME=$(dirname $(dirname $(readlink -f $(which javac))))

export CLASSPATH=$CLASSPATH:$CATALINA_HOME/bin/FDLogFormatter.jar

CURRENT_JAVA_VERSION=$("${JAVA_HOME}/bin/java" -version 2>&1 | grep version | awk -F '\"' '{print $2}')
if [ -z "${CURRENT_JAVA_VERSION}" ]
then
  CURRENT_JAVA_VERSION=$("${JAVA_HOME}/bin/java" -version 2>&1 | head -n 1 | awk -F '\"' '{print $2}') || exit 90
fi
echo "CSS was run with Java version ${CURRENT_JAVA_VERSION}"

if echo "${CURRENT_JAVA_VERSION}" | grep -c '^1\.8\.0' > /dev/null
then
  echo "Java 8 is not supported with CSS 9+. Java 21 or 17 is required. If you are running with Java 21 or 17, Please send this log to the Flexagon support team."
    exit 89
elif echo "${CURRENT_JAVA_VERSION}" | grep -c  '^21' > /dev/null
then
    CATALINA_OPTS='-Xlog:gc:file=$CATALINA_BASE/logs/gc-%t.log:time,level,tags -Xms${CSS_INITIAL_MEMORY_SIZE} -Xmx${CSS_MAX_MEMORY_SIZE} ${OMIT_STACK_TRACE_FAST_THROW} -Dflexagon.css.install.root="$CSS_APPLICATION_DIRECTORY" -Dflexagon.css.artifacts.root="$CSS_ARTIFACTS_DIRECTORY" -Djava.awt.headless=true -Djava.security.egd=file:/dev/./urandom -Dcom.sun.jndi.ldap.connect.pool.timeout="${CSS_LDAP_POOL_TIMEOUT}" -XX:+IgnoreUnrecognizedVMOptions --add-opens=java.base/java.net=ALL-UNNAMED --add-opens=java.base/sun.net.www.protocol.https=ALL-UNNAMED ${FLEXAGON_CSS_JAVA_ARGS}'
elif echo "${CURRENT_JAVA_VERSION}" | grep -c  '^17' > /dev/null
then
    CATALINA_OPTS='-Xlog:gc:file=$CATALINA_BASE/logs/gc-%t.log:time,level,tags -Xms${CSS_INITIAL_MEMORY_SIZE} -Xmx${CSS_MAX_MEMORY_SIZE} ${OMIT_STACK_TRACE_FAST_THROW} -Dflexagon.css.install.root="$CSS_APPLICATION_DIRECTORY" -Dflexagon.css.artifacts.root="$CSS_ARTIFACTS_DIRECTORY" -Djava.awt.headless=true -Djava.security.egd=file:/dev/./urandom -Dcom.sun.jndi.ldap.connect.pool.timeout="${CSS_LDAP_POOL_TIMEOUT}" -XX:+IgnoreUnrecognizedVMOptions --add-opens=java.base/java.net=ALL-UNNAMED --add-opens=java.base/sun.net.www.protocol.https=ALL-UNNAMED ${FLEXAGON_CSS_JAVA_ARGS}'
else
  echo "Unable to determine if Java version [${CURRENT_JAVA_VERSION}] is 17 or 21. Perhaps it is not either."
  echo "Only Java 21 and 17 are supported for CSS 9+. If you are running with Java 21 or 17, Please send this log to the Flexagon support team. Otherwise, please run with Java 21 or 17."
  exit 89
fi

