--Environment--
CREATE TABLE CSS.ENVIRONMENT
(
  ENVIRONMENT_ID NUMERIC(20) NOT NULL
, NAME VARCHAR(50) NOT NULL
, CODE VARCHAR(50) NOT NULL
, APPLICATION_TYPE VARCHAR(50) NOT NULL
, DESCRIPTION VARCHAR(255)
, IS_ACTIVE CHAR(1) NOT NULL
, SECURITY_OVERRIDDEN CHAR(1) DEFAULT 'N'
, CREATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8)
, CONSTRAINT ENVIRONMENT_PK PRIMARY KEY ( ENVIRONMENT_ID )
);

ALTER TABLE CSS.ENVIRONMENT
ADD CONSTRAINT ENVIRONMENT_UK1 UNIQUE
(
  CODE
);

ALTER TABLE CSS.ENVIRONMENT
ADD CONSTRAINT ENVIRONMENT_UK2 UNIQUE
(
  NAME
);

--Environment Property--
CREATE TABLE CSS.ENVIRONMENT_PROPERTY
(
  ENVIRONMENT_PROPERTY_ID NUMERIC(20) NOT NULL
, PROPERTY_CODE VARCHAR(120) NOT NULL
, ENVIRONMENT_ID NUMERIC(20, 0) NOT NULL
, PROPERTY_VALUE_SMALL VARCHAR(4000)
, PROPERTY_VALUE_LARGE TEXT
, CREDENTIAL_ID NUMERIC(20)
, IS_ACTIVE CHAR(1) NOT NULL
, CREATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8)
, CONSTRAINT ENVIRONMENT_PROPERTY_PK PRIMARY KEY
  (
    ENVIRONMENT_PROPERTY_ID
  )
);

ALTER TABLE CSS.ENVIRONMENT_PROPERTY
ADD CONSTRAINT ENVIRONMENT_PROPERTY_FK1 FOREIGN KEY
(
  ENVIRONMENT_ID
)
REFERENCES CSS.ENVIRONMENT
(
  ENVIRONMENT_ID
);

ALTER TABLE CSS.ENVIRONMENT_PROPERTY
ADD CONSTRAINT ENVIRONMENT_PROPERTY_UK1 UNIQUE
(
  ENVIRONMENT_ID,
  PROPERTY_CODE
);

--Plugin and Plugin Version--
CREATE TABLE CSS.PLUGIN
(
  PLUGIN_ID NUMERIC(20, 0) NOT NULL
, NAME VARCHAR(50) NOT NULL
, CODE VARCHAR(50) NOT NULL
, DESCRIPTION VARCHAR(255)
, APPLICATION_TYPE VARCHAR(50) NOT NULL
, IS_ACTIVE CHAR(1) NOT NULL
, ACTIVE_PLUGIN_VERSION_ID NUMERIC(20, 0)
, CREATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8, 0)
, CONSTRAINT PLUGIN_PK PRIMARY KEY
  (
    PLUGIN_ID
  )
);

CREATE TABLE CSS.PLUGIN_VERSION
(
  PLUGIN_VERSION_ID NUMERIC(20, 0) NOT NULL
, PLUGIN_ID NUMERIC(20, 0) NOT NULL
, PLUGIN_VERSION VARCHAR(255) NOT NULL
, DESCRIPTION VARCHAR(255)
, IS_ACTIVE CHAR(1) NOT NULL
, IS_DELETED CHAR(1) NOT NULL
, INSTALLED_ON TIMESTAMP NOT NULL
, INSTALLED_BY VARCHAR(128) NOT NULL
, CREATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8, 0)
, CONSTRAINT PLUGIN_VERSION_PK PRIMARY KEY
  (
    PLUGIN_VERSION_ID
  )
);

CREATE INDEX CSSIX24 ON CSS.PLUGIN (ACTIVE_PLUGIN_VERSION_ID ASC);

ALTER TABLE CSS.PLUGIN
ADD CONSTRAINT PLUGIN_UK1 UNIQUE
(
  NAME
);

ALTER TABLE CSS.PLUGIN
ADD CONSTRAINT PLUGIN_UK2 UNIQUE
(
  CODE
);

ALTER TABLE CSS.PLUGIN_VERSION
ADD CONSTRAINT PLUGIN_VERSION_UK1 UNIQUE
(
  PLUGIN_ID
, PLUGIN_VERSION
);

ALTER TABLE CSS.PLUGIN
ADD CONSTRAINT PLUGIN_FK1 FOREIGN KEY
(
  ACTIVE_PLUGIN_VERSION_ID
)
REFERENCES CSS.PLUGIN_VERSION
(
  PLUGIN_VERSION_ID
);

ALTER TABLE CSS.PLUGIN_VERSION
ADD CONSTRAINT PLUGIN_VERSIONS FOREIGN KEY
(
  PLUGIN_ID
)
REFERENCES CSS.PLUGIN
(
  PLUGIN_ID
);

--Run Settings--
CREATE TABLE CSS.RUN_SETTINGS (
  RUN_SETTINGS_ID NUMERIC(20, 0) NOT NULL
, NAME VARCHAR(50) NOT NULL
, DESCRIPTION VARCHAR(255)
, OWNER_ID NUMERIC(20, 0) NOT NULL
, DATA TEXT NOT NULL
, CREATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8, 0)
, CONSTRAINT RUN_SETTINGS_PK PRIMARY KEY ( RUN_SETTINGS_ID )
);

ALTER TABLE CSS.RUN_SETTINGS
ADD CONSTRAINT RUN_SETTINGS_FK1 FOREIGN KEY
(
  OWNER_ID
)
REFERENCES FF.FLX_USER
(
  USER_ID
);

ALTER TABLE CSS.RUN_SETTINGS
ADD CONSTRAINT RUN_SETTINGS_UK1 UNIQUE
(
  NAME,
  OWNER_ID
);

-- Process Definition
CREATE TABLE CSS.PROCESS_DEFINITION
(
  PROCESS_DEFINITION_ID NUMERIC(20, 0) NOT NULL
, OWNER_ID NUMERIC(20, 0) NOT NULL
, NAME VARCHAR(50) NOT NULL
, APPLICATION_TYPE VARCHAR(50) NOT NULL
, RUN_TYPE VARCHAR(50)
, DESCRIPTION VARCHAR(255)
, IS_ACTIVE CHAR(1) NOT NULL
, IS_DELETED CHAR(1) NOT NULL
, SECURITY_OVERRIDDEN CHAR(1) DEFAULT 'N'
, CREATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8, 0)
, CONSTRAINT PROCESS_DEFINITION_PK PRIMARY KEY ( PROCESS_DEFINITION_ID ) 
);

CREATE UNIQUE INDEX UQ_PROCESS_ACTIVE
    ON CSS.PROCESS_DEFINITION (OWNER_ID, NAME)
    WHERE IS_DELETED = 'N';

ALTER TABLE CSS.PROCESS_DEFINITION
ADD CONSTRAINT PROCESS_DEFINITION_FK1 FOREIGN KEY
(
  OWNER_ID
)
REFERENCES FF.FLX_USER
(
  USER_ID
)
;

CREATE TABLE CSS.PROCESS_DEFINITION_SCOPE 
(
  PROCESS_DEFINITION_SCOPE_ID NUMERIC(20, 0) NOT NULL
, PROCESS_DEFINITION_ID NUMERIC(20,0) NOT NULL
, CODE VARCHAR(50) NOT NULL
, SCOPE_DATA TEXT NOT NULL
, CREATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8, 0)
, CONSTRAINT PROCESS_DEFINITION_SCOPE_PK PRIMARY KEY ( PROCESS_DEFINITION_SCOPE_ID ) 
);

ALTER TABLE CSS.PROCESS_DEFINITION_SCOPE
ADD CONSTRAINT PROCESS_DEFINITION_SCOPE_FK1 FOREIGN KEY
(
  PROCESS_DEFINITION_ID
)
REFERENCES CSS.PROCESS_DEFINITION
(
  PROCESS_DEFINITION_ID
)
;

ALTER TABLE CSS.PROCESS_DEFINITION_SCOPE
ADD CONSTRAINT PROCESS_DEFINITION_SCOPE_UK1 UNIQUE
(
  PROCESS_DEFINITION_ID,
  CODE
)
;

-- Request
CREATE TABLE CSS.REQUEST (
  REQUEST_ID NUMERIC(20, 0) NOT NULL
, REQUESTED_BY_USER_ID NUMERIC(20, 0) NOT NULL
, REQUESTED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, NAME VARCHAR(255)
, PROCESS_DEFINITION_ID NUMERIC(20,0)
, RUN_TYPE VARCHAR(50) NOT NULL
, APPLICATION_TYPE VARCHAR(50) NOT NULL
, START_TIME TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP
, END_TIME TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP
, REQUEST_STATUS VARCHAR(50) NOT NULL
, CREATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8, 0)
, CONSTRAINT REQUEST_PK PRIMARY KEY ( REQUEST_ID )
);

ALTER TABLE CSS.REQUEST
ADD CONSTRAINT REQUEST_FK1 FOREIGN KEY
(
  REQUESTED_BY_USER_ID
)
REFERENCES FF.FLX_USER
(
  USER_ID
);

ALTER TABLE CSS.REQUEST
ADD CONSTRAINT REQUEST_FK2 FOREIGN KEY
(
  PROCESS_DEFINITION_ID
)
REFERENCES CSS.PROCESS_DEFINITION
(
  PROCESS_DEFINITION_ID
)
;

ALTER TABLE CSS.REQUEST
ADD CONSTRAINT REQUEST_NAME_UK1 UNIQUE
(
  NAME
)
;

-- Request Data Source
CREATE TABLE CSS.REQUEST_DATA_SOURCE (
  REQUEST_DATA_SOURCE_ID NUMERIC(20, 0) NOT NULL
, REQUEST_ID NUMERIC(20,0) NOT NULL
, SOURCE_TYPE VARCHAR(128) NOT NULL
, SOURCE_ID NUMERIC(20, 0) NOT NULL
, SORT_NUMBER NUMERIC(8,0) NOT NULL
, CREATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, CONSTRAINT REQUEST_DATA_SOURCE_PK PRIMARY KEY ( REQUEST_DATA_SOURCE_ID )
);

ALTER TABLE CSS.REQUEST_DATA_SOURCE
ADD CONSTRAINT REQUEST_DATA_SOURCE_FK1 FOREIGN KEY
(
  REQUEST_ID
)
REFERENCES CSS.REQUEST
(
  REQUEST_ID
);

-- Request Security
CREATE TABLE CSS.REQUEST_SECURITY (
  REQUEST_SECURITY_ID NUMERIC(20, 0) NOT NULL
, REQUEST_ID NUMERIC(20,0) NOT NULL
, OBJECT_TYPE VARCHAR(50) NOT NULL
, OBJECT_ID NUMERIC(20, 0) NOT NULL
, CREATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, CONSTRAINT REQUEST_SECURITY_PK PRIMARY KEY ( REQUEST_SECURITY_ID )
);

ALTER TABLE CSS.REQUEST_SECURITY
ADD CONSTRAINT REQUEST_SECURITY_FK1 FOREIGN KEY
(
  REQUEST_ID
)
REFERENCES CSS.REQUEST
(
  REQUEST_ID
)
;

CREATE INDEX IDX_REQUEST_SECURITY_FK1
    ON CSS.REQUEST (REQUEST_ID);

CREATE INDEX IDX_RS1
    ON CSS.REQUEST_SECURITY (OBJECT_TYPE, OBJECT_ID);

-- Request Input
CREATE TABLE CSS.REQUEST_INPUT (
  REQUEST_INPUT_ID NUMERIC(20, 0) NOT NULL
, REQUEST_ID NUMERIC(20,0) NOT NULL
, CODE VARCHAR(50) NOT NULL
, INPUT_DATA TEXT NOT NULL
, CREATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, CONSTRAINT REQUEST_INPUT_PK PRIMARY KEY ( REQUEST_INPUT_ID )
);

ALTER TABLE CSS.REQUEST_INPUT
ADD CONSTRAINT REQUEST_INPUT_FK1 FOREIGN KEY
(
  REQUEST_ID
)
REFERENCES CSS.REQUEST
(
  REQUEST_ID
);

ALTER TABLE CSS.REQUEST_INPUT
ADD CONSTRAINT REQUEST_INPUT_UK1 UNIQUE
(
  REQUEST_ID,
  CODE
);

--Execution
CREATE TABLE CSS.EXECUTION (
  EXECUTION_ID NUMERIC(20, 0) NOT NULL
, REQUEST_ID NUMERIC(20, 0) NOT NULL
, PLUGIN_VERSION_ID NUMERIC(20, 0) NOT NULL
, START_TIME TIMESTAMP
, END_TIME TIMESTAMP
, EXECUTION_STATUS VARCHAR(50) NOT NULL
, ERROR_MESSAGE VARCHAR(4000)
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8, 0)
, CONSTRAINT EXECUTION_PK PRIMARY KEY ( EXECUTION_ID )
);

ALTER TABLE CSS.EXECUTION
ADD CONSTRAINT EXECUTION_FK1 FOREIGN KEY
(
  REQUEST_ID
)
REFERENCES CSS.REQUEST
(
  REQUEST_ID
);

ALTER TABLE CSS.EXECUTION
ADD CONSTRAINT EXECUTION_FK2 FOREIGN KEY
(
  PLUGIN_VERSION_ID
)
REFERENCES CSS.PLUGIN_VERSION
(
  PLUGIN_VERSION_ID
);

--Execution Logs
CREATE TABLE CSS.EXECUTION_LOGS (
  EXECUTION_LOGS_ID NUMERIC(20, 0) NOT NULL
, EXECUTION_ID NUMERIC(20, 0) NOT NULL
, MESSAGE_DATE TIMESTAMP NOT NULL
, LOG_LEVEL VARCHAR(50) NOT NULL
, MESSAGE VARCHAR(4000) NOT NULL
, THREAD_NUMBER VARCHAR(10)
, CLASS_AND_METHOD VARCHAR(128)
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, CONSTRAINT EXECUTION_LOGS_PK PRIMARY KEY ( EXECUTION_LOGS_ID )
);

ALTER TABLE CSS.EXECUTION_LOGS
ADD CONSTRAINT EXECUTION_LOGS_FK1 FOREIGN KEY
(
  EXECUTION_ID
)
REFERENCES CSS.EXECUTION
(
  EXECUTION_ID
);

CREATE INDEX execution_logs_execution_id_idx
  ON css.execution_logs (execution_id);

CREATE INDEX execution_logs_message_date_idx
  ON css.execution_logs (message_date);

--Saved Queries

CREATE TABLE CSS.SAVED_QUERY
(
  SAVED_QUERY_ID NUMERIC(20, 0) NOT NULL
, PAGE_NAME VARCHAR(50) NOT NULL
, OWNER_ID NUMERIC(20, 0) NOT NULL
, NAME VARCHAR(50) NOT NULL
, SAVED_QUERY_DATA TEXT
, CREATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8, 0)
, CONSTRAINT SAVED_QUERY_PK PRIMARY KEY ( SAVED_QUERY_ID )
);

ALTER TABLE CSS.SAVED_QUERY
ADD CONSTRAINT SAVED_QUERY_UK1 UNIQUE
(
  NAME
, PAGE_NAME
, OWNER_ID
);

CREATE TABLE CSS.DATA_LOAD_TRACK 
(
  DATA_LOAD_TRACK_ID NUMERIC(20, 0) NOT NULL 
, FILE_NAME VARCHAR(255) NOT NULL 
, HASH VARCHAR(255) NOT NULL 
, CREATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP 
, CREATED_BY VARCHAR(128) NOT NULL 
, UPDATED_ON TIMESTAMP(6) WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP(6)
, UPDATED_BY VARCHAR(128) NOT NULL 
, VERSION_NUMBER NUMERIC(8, 0) 
, CONSTRAINT DATA_LOAD_TRACK_PK PRIMARY KEY 
  (
    DATA_LOAD_TRACK_ID 
  )
  
);

ALTER TABLE CSS.DATA_LOAD_TRACK
ADD CONSTRAINT DATA_LOAD_TRACK_UK1 UNIQUE 
(
  FILE_NAME 
)
;

-- License
CREATE TABLE CSS.LICENSE_INFO
(
  LICENSE_INFO_ID NUMERIC(20, 0) NOT NULL
, LICENSE_KEY TEXT NOT NULL
, CREATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8, 0)
, CONSTRAINT LICENSE_INFO_PK PRIMARY KEY
  (
    LICENSE_INFO_ID
  )

);

CREATE TABLE CSS.CSS_VERSION
(
  VERSION        VARCHAR(50)   NOT NULL,
    CREATED_ON     TIMESTAMP WITH TIME ZONE    DEFAULT CURRENT_TIMESTAMP,
    CREATED_BY     VARCHAR(128)  NOT NULL,
    UPDATED_ON     TIMESTAMP(6) WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP(6),
    UPDATED_BY     VARCHAR(128) NOT NULL,
    VERSION_NUMBER NUMERIC(8, 0)
);

-- Module
CREATE TABLE CSS.MODULE
(
  MODULE_ID NUMERIC(20, 0) NOT NULL
, PLUGIN_ID NUMERIC(20, 0) NOT NULL
, CODE VARCHAR(255) NOT NULL
, IS_ACTIVE CHAR(1) NOT NULL
, SECURITY_OVERRIDDEN CHAR(1) DEFAULT 'N'
, CREATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP NOT NULL
, CREATED_BY VARCHAR(128) NOT NULL
, UPDATED_ON TIMESTAMP WITH TIME ZONE  DEFAULT CURRENT_TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR(128) NOT NULL
, VERSION_NUMBER NUMERIC(8)
, CONSTRAINT MODULE_PK PRIMARY KEY
  (
    MODULE_ID
  )

);


ALTER TABLE CSS.MODULE
ADD CONSTRAINT MODULE_UK1 UNIQUE
(
  PLUGIN_ID
, CODE
)
;

ALTER TABLE CSS.MODULE
ADD CONSTRAINT MODULE_FK1 FOREIGN KEY
(
  PLUGIN_ID
)
REFERENCES CSS.PLUGIN
(
  PLUGIN_ID
)
;

CREATE OR REPLACE VIEW CSS.VOBJECTPERMISSION AS
    SELECT
        ug.user_id,
        p.object_id,
        p.object_type,
        p.action_type
    FROM
        FF.FLX_USER_group ug
        INNER JOIN FF.FLX_GROUP_permission gp ON ug.group_id = gp.group_id
        INNER JOIN FF.FLX_PERMISSION       p ON gp.permission_id = p.permission_id AND P.APPLICATION_OWNER='CSS'
    UNION
    SELECT
        ug.user_id,
        p.object_id,
        p.object_type,
        p.action_type
    FROM
        FF.FLX_USER_ext_group ug
        INNER JOIN FF.FLX_GROUP_permission gp ON ug.group_id = gp.group_id
        INNER JOIN FF.FLX_PERMISSION       p ON gp.permission_id = p.permission_id AND P.APPLICATION_OWNER='CSS';

grant select on CSS.VOBJECTPERMISSION to FD_ADMIN;

ALTER TABLE CSS.ENVIRONMENT_PROPERTY
ADD CONSTRAINT ENVIRONMENT_PROPERTY_FK2 FOREIGN KEY
(
  CREDENTIAL_ID
)
REFERENCES FF.CREDENTIAL
(
  CREDENTIAL_ID
);



-- ENVIRONMENT_PROPERTY → ENVIRONMENT
CREATE INDEX idx_environment_property_fk1
    ON CSS.ENVIRONMENT_PROPERTY (ENVIRONMENT_ID);

-- PLUGIN_VERSION → PLUGIN
CREATE INDEX idx_plugin_versions
    ON CSS.PLUGIN_VERSION (PLUGIN_ID);

-- MODULE → PLUGIN
CREATE INDEX idx_module_fk1
    ON CSS.MODULE (PLUGIN_ID);

-- REQUEST → PROCESS_DEFINITION
CREATE INDEX idx_request_fk2
    ON CSS.REQUEST (PROCESS_DEFINITION_ID);

-- EXECUTION → REQUEST
CREATE INDEX idx_execution_fk1
    ON CSS.EXECUTION (REQUEST_ID);

-- EXECUTION → PLUGIN_VERSION
CREATE INDEX idx_execution_fk2
    ON CSS.EXECUTION (PLUGIN_VERSION_ID);

-- REQUEST requested date
CREATE INDEX idx_request_requested_on
    ON CSS.REQUEST (REQUESTED_ON);

-- EXECUTION start time
CREATE INDEX idx_execution_start_time
    ON CSS.EXECUTION (START_TIME);