@echo off
cls

set CATALINA_HOME=%~dp0apache-tomcat-css
cd %~dp0apache-tomcat-css\webapps

if exist "css.war" (
    if exist "css.war.current" (
        del "css.war.current"
    )

    ren "css.war" "css.war.current"
)

if exist "css.war.current" (
    if exist "css" (
        rmdir /s /q "css"
    )
    mkdir "css"

	Powershell -command "& {Add-Type -AssemblyName System.IO.Compression.FileSystem ; [System.IO.Compression.ZipFile]::ExtractToDirectory(\"%CD%/css.war.current\", \"%CD%\css\")}" || unzip "css.war.current" -d "css" || exit /b 32
)


if exist "css" (
    echo css war is extracted and ready for use.
) else (
    echo css webapps folder is missing.
    exit /b 99
)

if not exist "css\WEB-INF\lib" (
    echo css webapps WEB-INF\lib folder is missing.
    exit /b 98
)

for %%F in ("..\..\apiext\*.jar") do (
    echo "API Extension Jar %%F found. Loading into your css install."
    copy "%%F" "css\WEB-INF\lib\" || exit /b 35
)

cd %~dp0apache-tomcat-css\bin

if exist "..\libext\xmlparserv2*.jar" (
    echo Removing xmlparserv2 jars from the libext folder to prevent startup issues.
    del /f "..\libext\xmlparse*.jar"
)

call startup.bat
cd %~dp0
echo. && echo. && echo The css server is starting. The first start will take a few minutes.

echo If you changed your tomcat port from 8001 to another port, please note that this script will not know that, so you should change the URL in the browser to match your changes.
echo You may update the StartWithPostgres.bat file with the new port number as well.

echo. && echo Your web browser will be launched when the timer reaches 0.
echo. && echo The server may not be fully up yet at that time. Please refresh the page periodically if you get a 404 error.

echo If you have trouble getting css to start, check documentation for troubleshooting tips.
echo Documentation is at http://wiki.flexagon.com, search for Running css with embedded database on Windows

timeout /t 45
start http://localhost:8001/css