#!/bin/sh
SCRIPT_DIR=$(CDPATH= cd -- "$(dirname -- "$0")" && pwd)

TCAT_HOME=${SCRIPT_DIR%/bin}
CSSPID=`ps -ef | grep ${TCAT_HOME} | grep java | grep -v grep | awk '{print $2}'`

if [ -z "${CSSPID}" ]; then
    HERE=$(pwd)
    cd "${SCRIPT_DIR}" || exit 20
    cd "../logs" || exit 25
    if [ -f catalina.out ]
    then
        CATALINA_BACKUP_LOG_FILE=catalina-$(date +"%y-%m-%d_%H-%M-%S").out
        mv catalina.out $CATALINA_BACKUP_LOG_FILE
        > catalina.out
    fi

    cd "${SCRIPT_DIR}/../webapps" || exit 30

    if ls "css.war" > /dev/null 2>&1
    then
      if ls css.war.current > /dev/null > /dev/null 2>&1
      then
        rm -f css.war.current
      fi

      mv css.war css.war.current
    fi

    if ls "css.war.current" > /dev/null 2>&1
    then
      if [ -d css ]
      then
        rm -rf css
      fi
      mkdir css
      unzip css.war.current -d css || exit 32
    fi

    if ls "css" > /dev/null
    then
      echo "CSS war is extracted and ready for use."
    else
      echo "CSS webapps folder is missing."
      exit 99
    fi

    if ! ls "css/WEB-INF/lib" > /dev/null
    then
      echo "CSS webapps WEB-INF/lib folder is missing."
      exit 98
    fi

    if ls "${SCRIPT_DIR}"/../../apiext/*.jar > /dev/null 2>&1
    then
      echo "API Extension Jar(s) found. Loading into your CSS install."
      cp "${SCRIPT_DIR}"/../../apiext/*.jar "${SCRIPT_DIR}/../webapps/css/WEB-INF/lib/" || exit 35
    fi

    if ls "${SCRIPT_DIR}"/../libext/xmlparserv2*.jar > /dev/null 2>&1
    then
      echo "Removing xmlparserv2 jars from the libext folder to prevent startup issues."
      rm -f "${SCRIPT_DIR}"/../libext/xmlparse*.jar
    fi

    cd "${SCRIPT_DIR}" || exit 40
    ./startup.sh
    cd "${HERE}" || echo "Unable to return to the original location."

else
    echo "CSS is already running. Not starting a second process."
fi
