if not exist "%CATALINA_BASE%\bin\setenvoverride.bat" goto checkSetenvoverrideHome
call "%CATALINA_BASE%\bin\setenvoverride.bat"
goto setenvoverrideDone
:checkSetenvoverrideHome
if exist "%CATALINA_HOME%\bin\setenvoverride.bat" call "%CATALINA_HOME%\bin\setenvoverride.bat"
:setenvoverrideDone

@rem get the current directory
set CURRENT_DIRECTORY=%CD%

@rem go up a directory
cd %CATALINA_HOME%/..

@rem capture this directory, this is where css is installed
set CSS_HOME=%CD%

@rem go back to the original directory
cd %CURRENT_DIRECTORY%

if not defined CSS_REPOSITORY_DIRECTORY (
    set CSS_REPOSITORY_DIRECTORY=%CSS_HOME%\artifacts
)

if not defined CSS_APPLICATION_DIRECTORY (
    set CSS_APPLICATION_DIRECTORY=%CSS_HOME%\application
)

@rem if no initial memory size, set to default
if not defined CSS_INITIAL_MEMORY_SIZE (
    set CSS_INITIAL_MEMORY_SIZE=1024m
)

@rem if no max memory size, set to default
if not defined CSS_MAX_MEMORY_SIZE (
    set CSS_MAX_MEMORY_SIZE=4096m
)

@rem if no CSS_LDAP_POOL_TIMEOUT, set to default of 5 minutes.
if not defined CSS_LDAP_POOL_TIMEOUT (
    set CSS_LDAP_POOL_TIMEOUT=300000
)


set "CLASSPATH=%CLASSPATH%;%CATALINA_HOME%\bin\FDLogFormatter.jar"

rem *************************************
rem if your Java install isn't found, set JAVA_HOME in setenvoverride.bat
rem *************************************

if "%JAVA_HOME%" == "" goto FindJREInRegistry
goto JavaHomeIsSet

:FindJREInRegistry
@echo JAVA_HOME is not set, looking for Java Runtime Environment in Registry.

setlocal ENABLEEXTENSIONS
FOR /F "usebackq skip=2 tokens=2,*" %%A IN (`REG QUERY "HKLM\SOFTWARE\JavaSoft\Java Runtime Environment" /v CurrentVersion 2^>nul`) DO (
    set JREValue=%%B
)

if "%JREValue%" == "" goto FindJDKInRegistry

@echo CurrentVersion for Java Runtime Environment is %JREValue%
if %JREValue% LSS 1.7  (
    @echo The Java Runtime Environment found in your registry is version 6 or older. Unable to use this version.
) else (
    @echo The Java Runtime Environment found in your registry looks good.
    FOR /F "usebackq skip=2 tokens=2,*" %%A IN (`REG QUERY "HKLM\SOFTWARE\JavaSoft\Java Runtime Environment\%JREValue%" /v JavaHome 2^>nul`) DO (
        endlocal
        set "DERIVED_JAVA_HOME=%%B"
    )
    @echo %DERIVED_JAVA_HOME%
    goto JavaHomeIsDerived
)

if NOT "%DERIVED_JAVA_HOME%" == "" goto JavaHomeIsDerived

:FindJDKInRegistry
@echo JAVA_HOME is not set, looking for Java Development Kit in Registry.

FOR /F "usebackq skip=2 tokens=2,*" %%A IN (`REG QUERY "HKLM\SOFTWARE\JavaSoft\Java Development Kit" /v CurrentVersion 2^>nul`) DO (
    set JDKValue=%%B
)

if "%JDKValue%" == "" goto JavaNotFoundInRegistry

@echo CurrentVersion for Java Development Kit is %JDKValue%
if %JDKValue% LSS 1.7  (
    @echo The Java Development Kit found in your registry is version 6 or older. Unable to use this version.
) else (
    @echo The Java Development Kit found in your registry looks good.
    FOR /F "usebackq skip=2 tokens=2,*" %%A IN (`REG QUERY "HKLM\SOFTWARE\JavaSoft\Java Development Kit\%JDKValue%" /v JavaHome 2^>nul`) DO (
        endlocal
        set "DERIVED_JAVA_HOME=%%B"
    )
    goto JavaHomeIsDerived
)

:JavaNotFoundInRegistry
@echo Java was not found in your registry. Set JAVA_HOME variable in file, "%~dp0setenv.bat"
pause >nul && pause
exit 1


:JavaHomeIsDerived
set JAVA_HOME=%DERIVED_JAVA_HOME%

:JavaHomeIsSet
@echo Inside setenv.bat file JAVA_HOME is set to "%JAVA_HOME%"
@echo.

@rem Check the value of $CSS_COOKIE_SECURE
if "%$CSS_COOKIE_SECURE%"=="0" (
    @rem Replace <secure>true</secure> with <secure>false</secure>
    powershell -Command "(Get-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml') -replace '<secure>true</secure>', '<secure>false</secure>' | Set-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml'"
) else if "%$CSS_COOKIE_SECURE%"=="1" (
    @rem Replace <secure>false</secure> with <secure>true</secure>
    powershell -Command "(Get-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml') -replace '<secure>false</secure>', '<secure>true</secure>' | Set-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml'"
)

@rem Check the value of HSTS
if "%$CSS_HSTS%"=="0" (
    @rem Comment out the HSTS section
    powershell -Command "(Get-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml') -replace '<!-- Start HSTS Section-->', '<!-- Start HSTS Section.' | Set-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml'"
    powershell -Command "(Get-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml') -replace '<!-- End HSTS Section-->', '  End HSTS Section-->' | Set-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml'"
) else if "%$CSS_HSTS%"=="1" (
    @rem Restore the HSTS section
    powershell -Command "(Get-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml') -replace '<!-- Start HSTS Section.', '<!-- Start HSTS Section-->' | Set-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml'"
    powershell -Command "(Get-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml') -replace '  End HSTS Section-->', '<!-- End HSTS Section-->' | Set-Content -Path '%CATALINA_BASE%\webapps\css\WEB-INF\web.xml'"
)

if "%ENABLE_OMIT_STACK_TRACE_FAST_THROW%"=="1" (
    set OMIT_STACK_TRACE_FAST_THROW=
) else (
    set OMIT_STACK_TRACE_FAST_THROW=-XX:-OmitStackTraceInFastThrow
)

@rem Get the current Java version
for /f "tokens=*" %%i in ('"%JAVA_HOME%\bin\java" -version 2^>^&1') do set "CURRENT_JAVA_VERSION=%%i"

echo Running CSS with Java version %CURRENT_JAVA_VERSION%
@rem  Check if it's Java 8
echo %CURRENT_JAVA_VERSION% | findstr /r "1\.8\.0" > nul
if %errorlevel% equ 0 (
    echo Java 8 is not supported for CSS. Java 21 or 17 is required.
    echo If you are running with Java 21 or 17, Please send this log to the Flexagon support team.
	pause >nul && pause
    exit 89
)

@rem Check if it's Java 21
echo %CURRENT_JAVA_VERSION% | findstr /r "21" > nul
if %errorlevel% equ 0 (
    set "CATALINA_OPTS=-Xlog:gc:file=%CATALINA_BASE%\logs\gc-%%t.log:time,level,tags -Xms%CSS_INITIAL_MEMORY_SIZE% -Xmx%CSS_MAX_MEMORY_SIZE% %OMIT_STACK_TRACE_FAST_THROW% -Dflexagon.css.install.root="%CSS_APPLICATION_DIRECTORY%" -Dflexagon.css.repository.root="%CSS_REPOSITORY_DIRECTORY%" -Djava.awt.headless=true -Dcom.sun.jndi.ldap.connect.pool.timeout="%CSS_LDAP_POOL_TIMEOUT%" -XX:+IgnoreUnrecognizedVMOptions --add-opens=java.base/java.net=ALL-UNNAMED --add-opens=java.base/sun.net.www.protocol.https=ALL-UNNAMED  %FLEXAGON_CSS_JAVA_ARGS%"
	GOTO LAUNCH
)
echo %CURRENT_JAVA_VERSION% | findstr /r "17" > nul
if %errorlevel% equ 0 (
	set "CATALINA_OPTS=-Xlog:gc:file=%CATALINA_BASE%\logs\gc-%%t.log:time,level,tags -Xms%CSS_INITIAL_MEMORY_SIZE% -Xmx%CSS_MAX_MEMORY_SIZE% %OMIT_STACK_TRACE_FAST_THROW% -Dflexagon.css.install.root="%CSS_APPLICATION_DIRECTORY%" -Dflexagon.css.repository.root="%CSS_REPOSITORY_DIRECTORY%" -Djava.awt.headless=true -Dcom.sun.jndi.ldap.connect.pool.timeout="%CSS_LDAP_POOL_TIMEOUT%" -XX:+IgnoreUnrecognizedVMOptions --add-opens=java.base/java.net=ALL-UNNAMED --add-opens=java.base/sun.net.www.protocol.https=ALL-UNNAMED  %FLEXAGON_CSS_JAVA_ARGS%"
	GOTO LAUNCH
)
echo Unable to determine if Java version was 21 or 17. Perhaps it is not either.
echo Only Java 21 and 17 are supported for CSS. If you are running with Java 21 or 17, Please send this log to the Flexagon support team. Otherwise, please run with Java 21 or 17.
pause >nul && pause
exit 89


:LAUNCH
echo Launching CSS.