GRANT REFERENCES ON FF.CREDENTIAL TO CSS;
GRANT REFERENCES ON FF.FLX_GROUP TO CSS;
GRANT REFERENCES ON FF.FLX_GROUP_PERMISSION TO CSS;
GRANT REFERENCES ON FF.FLX_USER TO CSS;
GRANT REFERENCES ON FF.FLX_PERMISSION TO CSS;
GRANT REFERENCES ON FF.FLX_USER_GROUP TO CSS;
GRANT REFERENCES ON FF.FLX_USER_EXT_GROUP TO CSS;


--Environment--
CREATE TABLE CSS.ENVIRONMENT
(
  ENVIRONMENT_ID NUMBER(20, 0) NOT NULL
, NAME VARCHAR2(50) NOT NULL
, CODE VARCHAR2(50) NOT NULL
, APPLICATION_TYPE VARCHAR2(50) NOT NULL
, DESCRIPTION VARCHAR2(255)
, IS_ACTIVE CHAR(1) NOT NULL
, SECURITY_OVERRIDDEN CHAR(1) DEFAULT 'N'
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT ENVIRONMENT_PK PRIMARY KEY ( ENVIRONMENT_ID ) ENABLE
);

CREATE UNIQUE INDEX CSS.ENVIRONMENT_UK1 ON CSS.ENVIRONMENT (CODE ASC );
CREATE UNIQUE INDEX CSS.ENVIRONMENT_UK2 ON CSS.ENVIRONMENT (NAME ASC);

ALTER TABLE CSS.ENVIRONMENT
ADD CONSTRAINT ENVIRONMENT_UK1 UNIQUE
(
  CODE
)
ENABLE;

ALTER TABLE CSS.ENVIRONMENT
ADD CONSTRAINT ENVIRONMENT_UK2 UNIQUE
(
  NAME
)
ENABLE;

--Environment Property--
CREATE TABLE CSS.ENVIRONMENT_PROPERTY
(
  ENVIRONMENT_PROPERTY_ID NUMBER(20, 0) NOT NULL
, PROPERTY_CODE VARCHAR2(120) NOT NULL
, ENVIRONMENT_ID NUMBER(20, 0) NOT NULL
, PROPERTY_VALUE_SMALL VARCHAR2(4000)
, PROPERTY_VALUE_LARGE CLOB
, CREDENTIAL_ID NUMBER(20, 0)
, IS_ACTIVE CHAR(1) NOT NULL
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT ENVIRONMENT_PROPERTY_PK PRIMARY KEY
  (
    ENVIRONMENT_PROPERTY_ID
  )
  ENABLE
);

CREATE UNIQUE INDEX CSS.ENVIRONMENT_PROPERTY_UK1 ON CSS.ENVIRONMENT_PROPERTY (ENVIRONMENT_ID ASC, PROPERTY_CODE ASC );

ALTER TABLE CSS.ENVIRONMENT_PROPERTY
ADD CONSTRAINT ENVIRONMENT_PROPERTY_FK1 FOREIGN KEY
(
  ENVIRONMENT_ID
)
REFERENCES CSS.ENVIRONMENT
(
  ENVIRONMENT_ID
)
ENABLE;

ALTER TABLE CSS.ENVIRONMENT_PROPERTY
ADD CONSTRAINT ENVIRONMENT_PROPERTY_UK1 UNIQUE
(
  ENVIRONMENT_ID,
  PROPERTY_CODE
)
ENABLE;

--Plugin and Plugin Version--
CREATE TABLE CSS.PLUGIN
(
  PLUGIN_ID NUMBER(20, 0) NOT NULL
, NAME VARCHAR2(50) NOT NULL
, CODE VARCHAR2(50) NOT NULL
, DESCRIPTION VARCHAR2(255)
, APPLICATION_TYPE VARCHAR2(50) NOT NULL
, IS_ACTIVE CHAR(1) NOT NULL
, ACTIVE_PLUGIN_VERSION_ID NUMBER(20, 0)
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT PLUGIN_PK PRIMARY KEY
  (
    PLUGIN_ID
  )
  ENABLE
);

CREATE TABLE CSS.PLUGIN_VERSION
(
  PLUGIN_VERSION_ID NUMBER(20, 0) NOT NULL
, PLUGIN_ID NUMBER(20, 0) NOT NULL
, PLUGIN_VERSION VARCHAR2(255) NOT NULL
, DESCRIPTION VARCHAR2(255)
, IS_ACTIVE CHAR(1) NOT NULL
, IS_DELETED CHAR(1) NOT NULL
, INSTALLED_ON TIMESTAMP NOT NULL
, INSTALLED_BY VARCHAR2(128) NOT NULL
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT PLUGIN_VERSION_PK PRIMARY KEY
  (
    PLUGIN_VERSION_ID
  )
  ENABLE
);

CREATE INDEX CSS.CSSIX24 ON CSS.PLUGIN (ACTIVE_PLUGIN_VERSION_ID ASC);
CREATE UNIQUE INDEX CSS.PLUGIN_UK1 ON CSS.PLUGIN (NAME ASC);
CREATE UNIQUE INDEX CSS.PLUGIN_VERSION_UK1 ON CSS.PLUGIN_VERSION (PLUGIN_ID ASC, PLUGIN_VERSION ASC);

ALTER TABLE CSS.PLUGIN
ADD CONSTRAINT PLUGIN_UK1 UNIQUE
(
  NAME
)
ENABLE;

ALTER TABLE CSS.PLUGIN
ADD CONSTRAINT PLUGIN_UK2 UNIQUE
(
  CODE
)
ENABLE;

ALTER TABLE CSS.PLUGIN_VERSION
ADD CONSTRAINT PLUGIN_VERSION_UK1 UNIQUE
(
  PLUGIN_ID
, PLUGIN_VERSION
)
ENABLE;

ALTER TABLE CSS.PLUGIN
ADD CONSTRAINT PLUGIN_FK1 FOREIGN KEY
(
  ACTIVE_PLUGIN_VERSION_ID
)
REFERENCES CSS.PLUGIN_VERSION
(
  PLUGIN_VERSION_ID
)
ENABLE;

ALTER TABLE CSS.PLUGIN_VERSION
ADD CONSTRAINT PLUGIN_VERSIONS FOREIGN KEY
(
  PLUGIN_ID
)
REFERENCES CSS.PLUGIN
(
  PLUGIN_ID
)
ENABLE;

--Run Settings--
CREATE TABLE CSS.RUN_SETTINGS (
  RUN_SETTINGS_ID NUMBER(20, 0) NOT NULL
, NAME VARCHAR2(50) NOT NULL
, DESCRIPTION VARCHAR2(255)
, OWNER_ID NUMBER(20, 0) NOT NULL
, DATA CLOB NOT NULL
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT RUN_SETTINGS_PK PRIMARY KEY ( RUN_SETTINGS_ID ) ENABLE
);

CREATE UNIQUE INDEX CSS.RUN_SETTINGS_UK1 ON CSS.RUN_SETTINGS (NAME ASC, OWNER_ID ASC );

ALTER TABLE CSS.RUN_SETTINGS
ADD CONSTRAINT RUN_SETTINGS_FK1 FOREIGN KEY
(
  OWNER_ID
)
REFERENCES FF.FLX_USER
(
  USER_ID
)
ENABLE;

ALTER TABLE CSS.RUN_SETTINGS
ADD CONSTRAINT RUN_SETTINGS_UK1 UNIQUE
(
  NAME,
  OWNER_ID
)
ENABLE;

-- Process Definition
CREATE TABLE CSS.PROCESS_DEFINITION
(
  PROCESS_DEFINITION_ID NUMBER(20, 0) NOT NULL
, OWNER_ID NUMBER(20, 0) NOT NULL
, NAME VARCHAR2(50) NOT NULL
, APPLICATION_TYPE VARCHAR2(50) NOT NULL
, RUN_TYPE VARCHAR2(50)
, DESCRIPTION VARCHAR2(255)
, IS_ACTIVE CHAR(1) NOT NULL
, IS_DELETED CHAR(1) NOT NULL
, SECURITY_OVERRIDDEN CHAR(1) DEFAULT 'N'
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT PROCESS_DEFINITION_PK PRIMARY KEY ( PROCESS_DEFINITION_ID ) ENABLE
);

CREATE UNIQUE INDEX CSS.UQ_PROCESS_ACTIVE
ON CSS.PROCESS_DEFINITION (
    CASE WHEN IS_DELETED = 'N' THEN OWNER_ID END,
    CASE WHEN IS_DELETED = 'N' THEN NAME END
);

ALTER TABLE CSS.PROCESS_DEFINITION
ADD CONSTRAINT PROCESS_DEFINITION_FK1 FOREIGN KEY
(
  OWNER_ID
)
REFERENCES FF.FLX_USER
(
  USER_ID
)
ENABLE;

CREATE TABLE CSS.PROCESS_DEFINITION_SCOPE 
(
  PROCESS_DEFINITION_SCOPE_ID NUMBER(20, 0) NOT NULL
, PROCESS_DEFINITION_ID NUMBER(20,0) NOT NULL
, CODE VARCHAR2(50) NOT NULL
, SCOPE_DATA CLOB NOT NULL
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT PROCESS_DEFINITION_SCOPE_PK PRIMARY KEY ( PROCESS_DEFINITION_SCOPE_ID ) ENABLE
);

ALTER TABLE CSS.PROCESS_DEFINITION_SCOPE
ADD CONSTRAINT PROCESS_DEFINITION_SCOPE_FK1 FOREIGN KEY
(
  PROCESS_DEFINITION_ID
)
REFERENCES CSS.PROCESS_DEFINITION
(
  PROCESS_DEFINITION_ID
)
ENABLE;

CREATE UNIQUE INDEX CSS.PROCESS_DEFINITION_SCOPE_UK1 ON CSS.PROCESS_DEFINITION_SCOPE (PROCESS_DEFINITION_ID ASC, CODE ASC);

ALTER TABLE CSS.PROCESS_DEFINITION_SCOPE
ADD CONSTRAINT PROCESS_DEFINITION_SCOPE_UK1 UNIQUE
(
  PROCESS_DEFINITION_ID,
  CODE
)
ENABLE;

-- Request
CREATE TABLE CSS.REQUEST (
  REQUEST_ID NUMBER(20, 0) NOT NULL
, REQUESTED_BY_USER_ID NUMBER(20, 0) NOT NULL
, REQUESTED_ON TIMESTAMP NOT NULL
, NAME VARCHAR2(255)
, PROCESS_DEFINITION_ID NUMBER(20,0)
, RUN_TYPE VARCHAR2(50) NOT NULL
, APPLICATION_TYPE VARCHAR2(50) NOT NULL
, START_TIME TIMESTAMP
, END_TIME TIMESTAMP
, REQUEST_STATUS VARCHAR2(50) NOT NULL
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT REQUEST_PK PRIMARY KEY ( REQUEST_ID ) ENABLE
);

ALTER TABLE CSS.REQUEST
ADD CONSTRAINT REQUEST_FK1 FOREIGN KEY
(
  REQUESTED_BY_USER_ID
)
REFERENCES FF.FLX_USER
(
  USER_ID
)
ENABLE;

ALTER TABLE CSS.REQUEST
ADD CONSTRAINT REQUEST_FK2 FOREIGN KEY
(
  PROCESS_DEFINITION_ID
)
REFERENCES CSS.PROCESS_DEFINITION
(
  PROCESS_DEFINITION_ID
)
ENABLE;

ALTER TABLE CSS.REQUEST
ADD CONSTRAINT REQUEST_NAME_UK1 UNIQUE
(
  NAME
)
ENABLE;

-- Request Data Source
CREATE TABLE CSS.REQUEST_DATA_SOURCE (
  REQUEST_DATA_SOURCE_ID NUMBER(20, 0) NOT NULL
, REQUEST_ID NUMBER(20,0) NOT NULL
, SOURCE_TYPE VARCHAR2(128) NOT NULL
, SOURCE_ID NUMBER(20, 0) NOT NULL
, SORT_NUMBER NUMBER(8,0) NOT NULL
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, CONSTRAINT REQUEST_DATA_SOURCE_PK PRIMARY KEY ( REQUEST_DATA_SOURCE_ID ) ENABLE
);

ALTER TABLE CSS.REQUEST_DATA_SOURCE
ADD CONSTRAINT REQUEST_DATA_SOURCE_FK1 FOREIGN KEY
(
  REQUEST_ID
)
REFERENCES CSS.REQUEST
(
  REQUEST_ID
)
ENABLE;

-- Request Security
CREATE TABLE CSS.REQUEST_SECURITY (
  REQUEST_SECURITY_ID NUMBER(20, 0) NOT NULL
, REQUEST_ID NUMBER(20,0) NOT NULL
, OBJECT_TYPE VARCHAR2(50) NOT NULL
, OBJECT_ID NUMBER(20, 0) NOT NULL
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, CONSTRAINT REQUEST_SECURITY_PK PRIMARY KEY ( REQUEST_SECURITY_ID ) ENABLE
);

ALTER TABLE CSS.REQUEST_SECURITY
ADD CONSTRAINT REQUEST_SECURITY_FK1 FOREIGN KEY
(
  REQUEST_ID
)
REFERENCES CSS.REQUEST
(
  REQUEST_ID
)
ENABLE;

CREATE INDEX CSS.IDX_REQUEST_SECURITY_FK1
    ON CSS.REQUEST_SECURITY (REQUEST_ID);

CREATE INDEX CSS.IDX_RS1
    ON CSS.REQUEST_SECURITY (OBJECT_TYPE, OBJECT_ID);

-- Request Input
CREATE TABLE CSS.REQUEST_INPUT (
  REQUEST_INPUT_ID NUMBER(20, 0) NOT NULL
, REQUEST_ID NUMBER(20,0) NOT NULL
, CODE VARCHAR2(50) NOT NULL
, INPUT_DATA CLOB NOT NULL
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, CONSTRAINT REQUEST_INPUT_PK PRIMARY KEY ( REQUEST_INPUT_ID ) ENABLE
);

ALTER TABLE CSS.REQUEST_INPUT
ADD CONSTRAINT REQUEST_INPUT_FK1 FOREIGN KEY
(
  REQUEST_ID
)
REFERENCES CSS.REQUEST
(
  REQUEST_ID
)
ENABLE;

CREATE UNIQUE INDEX CSS.REQUEST_INPUT_UK1 ON CSS.REQUEST_INPUT (REQUEST_ID ASC, CODE ASC);

ALTER TABLE CSS.REQUEST_INPUT
ADD CONSTRAINT REQUEST_INPUT_UK1 UNIQUE
(
  REQUEST_ID,
  CODE
)
ENABLE;

--Execution
CREATE TABLE CSS.EXECUTION (
  EXECUTION_ID NUMBER(20, 0) NOT NULL
, REQUEST_ID NUMBER(20, 0) NOT NULL
, PLUGIN_VERSION_ID NUMBER(20, 0) NOT NULL
, START_TIME TIMESTAMP
, END_TIME TIMESTAMP
, EXECUTION_STATUS VARCHAR2(50) NOT NULL
, ERROR_MESSAGE VARCHAR2(4000)
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT EXECUTION_PK PRIMARY KEY ( EXECUTION_ID ) ENABLE
);

ALTER TABLE CSS.EXECUTION
ADD CONSTRAINT EXECUTION_FK1 FOREIGN KEY
(
  REQUEST_ID
)
REFERENCES CSS.REQUEST
(
  REQUEST_ID
)
ENABLE;

ALTER TABLE CSS.EXECUTION
ADD CONSTRAINT EXECUTION_FK2 FOREIGN KEY
(
  PLUGIN_VERSION_ID
)
REFERENCES CSS.PLUGIN_VERSION
(
  PLUGIN_VERSION_ID
)
ENABLE;

--Execution Logs
CREATE TABLE CSS.EXECUTION_LOGS (
  EXECUTION_LOGS_ID NUMBER(20, 0) NOT NULL
, EXECUTION_ID NUMBER(20, 0) NOT NULL
, MESSAGE_DATE TIMESTAMP NOT NULL
, LOG_LEVEL VARCHAR2(50) NOT NULL
, MESSAGE VARCHAR2(4000) NOT NULL
, THREAD_NUMBER VARCHAR2(10)
, CLASS_AND_METHOD VARCHAR2(128)
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, CONSTRAINT EXECUTION_LOGS_PK PRIMARY KEY ( EXECUTION_LOGS_ID ) ENABLE
);

ALTER TABLE CSS.EXECUTION_LOGS
ADD CONSTRAINT EXECUTION_LOGS_FK1 FOREIGN KEY
(
  EXECUTION_ID
)
REFERENCES CSS.EXECUTION
(
  EXECUTION_ID
)
ENABLE;

CREATE INDEX CSS.EXECUTION_LOGS_EXECID_IDX
  ON CSS.EXECUTION_LOGS (EXECUTION_ID);

CREATE INDEX CSS.EXECUTION_LOGS_MSG_DATE_IDX
  ON CSS.EXECUTION_LOGS (MESSAGE_DATE);

-- Saved Queries
CREATE TABLE CSS.SAVED_QUERY
(
  SAVED_QUERY_ID NUMBER(20, 0) NOT NULL
, PAGE_NAME VARCHAR2(50) NOT NULL
, OWNER_ID NUMBER(20, 0) NOT NULL
, NAME VARCHAR2(50) NOT NULL
, SAVED_QUERY_DATA CLOB
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT SAVED_QUERY_PK PRIMARY KEY ( SAVED_QUERY_ID ) ENABLE
);

ALTER TABLE CSS.SAVED_QUERY
ADD CONSTRAINT SAVED_QUERY_UK1 UNIQUE
(
  NAME
, PAGE_NAME
, OWNER_ID
)
ENABLE;

CREATE TABLE CSS.DATA_LOAD_TRACK 
(
  DATA_LOAD_TRACK_ID NUMBER(20, 0) NOT NULL 
, FILE_NAME VARCHAR2(255) NOT NULL 
, HASH VARCHAR2(255) NOT NULL 
, CREATED_ON TIMESTAMP NOT NULL 
, CREATED_BY VARCHAR2(128) NOT NULL 
, UPDATED_ON TIMESTAMP(6) NOT NULL 
, UPDATED_BY VARCHAR2(128 BYTE) NOT NULL 
, VERSION_NUMBER NUMBER(8, 0) 
, CONSTRAINT DATA_LOAD_TRACK_PK PRIMARY KEY 
  (
    DATA_LOAD_TRACK_ID 
  )
  ENABLE 
);

ALTER TABLE CSS.DATA_LOAD_TRACK
ADD CONSTRAINT DATA_LOAD_TRACK_UK1 UNIQUE 
(
  FILE_NAME 
)
ENABLE;

-- License
CREATE TABLE CSS.LICENSE_INFO
(
  LICENSE_INFO_ID NUMBER(20, 0) NOT NULL
, LICENSE_KEY CLOB NOT NULL
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT LICENSE_INFO_PK PRIMARY KEY
  (
    LICENSE_INFO_ID
  )
  ENABLE
);

CREATE TABLE CSS.CSS_VERSION
(
    VERSION        VARCHAR2(50 BYTE)  NOT NULL,
    CREATED_ON     TIMESTAMP(6)       NOT NULL,
    CREATED_BY     VARCHAR2(128 BYTE) NOT NULL,
    UPDATED_ON     TIMESTAMP(6)       NOT NULL,
    UPDATED_BY     VARCHAR2(128 BYTE) NOT NULL,
    VERSION_NUMBER NUMBER(8, 0)
);

-- Module
CREATE TABLE CSS.MODULE
(
  MODULE_ID NUMBER(20, 0) NOT NULL
, PLUGIN_ID NUMBER(20, 0) NOT NULL
, CODE VARCHAR2(255) NOT NULL
, IS_ACTIVE CHAR(1) NOT NULL
, SECURITY_OVERRIDDEN CHAR(1) DEFAULT 'N'
, CREATED_ON TIMESTAMP NOT NULL
, CREATED_BY VARCHAR2(128) NOT NULL
, UPDATED_ON TIMESTAMP NOT NULL
, UPDATED_BY VARCHAR2(128) NOT NULL
, VERSION_NUMBER NUMBER(8, 0)
, CONSTRAINT MODULE_PK PRIMARY KEY
  (
    MODULE_ID
  )
  ENABLE
);

CREATE UNIQUE INDEX CSS.MODULE_UK1 ON CSS.MODULE (PLUGIN_ID ASC, CODE ASC);

ALTER TABLE CSS.MODULE
ADD CONSTRAINT MODULE_UK1 UNIQUE
(
  PLUGIN_ID
, CODE
)
ENABLE;

ALTER TABLE CSS.MODULE
ADD CONSTRAINT MODULE_FK1 FOREIGN KEY
(
  PLUGIN_ID
)
REFERENCES CSS.PLUGIN
(
  PLUGIN_ID
)
ENABLE;


GRANT SELECT ON FF.FLX_PERMISSION TO CSS WITH GRANT OPTION;
GRANT SELECT ON FF.FLX_GROUP_PERMISSION TO CSS WITH GRANT OPTION;
GRANT SELECT ON FF.FLX_USER_GROUP TO CSS WITH GRANT OPTION;
GRANT SELECT ON FF.FLX_USER_EXT_GROUP TO CSS WITH GRANT OPTION;

CREATE OR REPLACE VIEW CSS.VOBJECTPERMISSION AS
    SELECT
        ug.user_id,
        p.object_id,
        p.object_type,
        p.action_type
    FROM
        FF.FLX_USER_group ug
        INNER JOIN FF.FLX_GROUP_permission gp ON ug.group_id = gp.group_id
        INNER JOIN FF.FLX_PERMISSION       p ON gp.permission_id = p.permission_id AND P.APPLICATION_OWNER='CSS'
    UNION
    SELECT
        ug.user_id,
        p.object_id,
        p.object_type,
        p.action_type
    FROM
        FF.FLX_USER_ext_group ug
        INNER JOIN FF.FLX_GROUP_permission gp ON ug.group_id = gp.group_id
        INNER JOIN FF.FLX_PERMISSION       p ON gp.permission_id = p.permission_id and P.APPLICATION_OWNER='CSS';

grant select on CSS.VOBJECTPERMISSION to fd_admin;

ALTER TABLE CSS.ENVIRONMENT_PROPERTY
ADD CONSTRAINT ENVIRONMENT_PROPERTY_FK2 FOREIGN KEY
(
  CREDENTIAL_ID
)
REFERENCES FF.CREDENTIAL
(
  CREDENTIAL_ID
)
ENABLE;



-- ENVIRONMENT_PROPERTY → ENVIRONMENT
CREATE INDEX css.idx_environment_property_fk1
    ON CSS.ENVIRONMENT_PROPERTY (ENVIRONMENT_ID);

-- PLUGIN_VERSION → PLUGIN
CREATE INDEX css.idx_plugin_versions
    ON CSS.PLUGIN_VERSION (PLUGIN_ID);

-- MODULE → PLUGIN
CREATE INDEX css.idx_module_fk1
    ON CSS.MODULE (PLUGIN_ID);

-- REQUEST → PROCESS_DEFINITION
CREATE INDEX css.idx_request_fk2
    ON CSS.REQUEST (PROCESS_DEFINITION_ID);

-- EXECUTION → REQUEST
CREATE INDEX css.idx_execution_fk1
    ON CSS.EXECUTION (REQUEST_ID);

-- EXECUTION → PLUGIN_VERSION
CREATE INDEX css.idx_execution_fk2
    ON CSS.EXECUTION (PLUGIN_VERSION_ID);

-- REQUEST requested date
CREATE INDEX css.idx_request_requested_on
    ON CSS.REQUEST (REQUESTED_ON);

-- EXECUTION start time
CREATE INDEX css.idx_execution_start_time
    ON CSS.EXECUTION (START_TIME);
