/*
 * Decompiled with CFR 0.152.
 */
package flexagon.css.installer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.driver.OracleDriver;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.dbsupport.SqlStatement;
import org.postgresql.Driver;

public class DatabaseManagementUtils {
    private String url;
    private String host;
    private String port;
    private String databaseName;
    private String username;
    private String password;
    private String dbType;
    private String upgradeDirPath;
    private String logFilePath;
    private String schemaPassword;
    private String exportDirectory;
    private String prereqUserType;
    private String limitedUser;
    static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss a");
    static final double TEN_DOT_O = DatabaseManagementUtils.doubleVersionOf("10.0.0.0");
    Comparator<File> versionComparator = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            String[] folderNameParts = o1.getName().split("-to-");
            double fromVersionLong = DatabaseManagementUtils.doubleVersionOf(folderNameParts[0].trim().replace("v", ""));
            String[] folderNameParts2 = o2.getName().split("-to-");
            double fromVersionLong2 = DatabaseManagementUtils.doubleVersionOf(folderNameParts2[0].trim().replace("v", ""));
            return Double.compare(fromVersionLong, fromVersionLong2);
        }
    };

    public DatabaseManagementUtils() {
    }

    public DatabaseManagementUtils(String url) throws SQLException {
        this.url = url;
        this.registerDriver();
    }

    public String getCurrentVersion() throws SQLException {
        this.logMessage("Getting CSS version from CSS_VERSION table.");
        String version = null;
        String fiveVersion = null;
        try (Connection con = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
             Statement stmt = con.createStatement();){
            con.setAutoCommit(true);
            try (ResultSet rs = stmt.executeQuery("SELECT VERSION, UPDATED_BY  FROM CSS.CSS_VERSION WHERE VERSION NOT LIKE '%DEV%' AND VERSION NOT LIKE '%Patch%' ORDER BY cast(substr(version,0,3) as numeric) DESC, VERSION DESC");){
                while (version == null && rs.next()) {
                    String[] versionPartsArr;
                    version = rs.getString(1);
                    if (version.equalsIgnoreCase("5.5.0.x")) {
                        this.logMessage("Found CSS version " + version + " in the database. Setting to 5.6.0.0");
                        version = "5.6.0.0";
                    }
                    if ((versionPartsArr = version.split("\\.")).length <= 4) continue;
                    fiveVersion = this.fiveOfFour(version);
                    version = null;
                }
            }
            if (version == null) {
                version = fiveVersion;
            }
        }
        catch (SQLException e) {
            this.logError("Exception occurred while executing SQL Script to get CSS version.");
            throw e;
        }
        if (version != null) {
            this.logMessage("Found CSS version " + version);
        } else {
            this.logMessage("No CSS version found.");
        }
        return version;
    }

    String fiveOfFour(String version) {
        String[] versionPartsArr = version.split("\\.");
        List<String> versionParts = Arrays.asList(versionPartsArr).subList(0, versionPartsArr.length - 1);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String part : versionParts) {
            sb.append(part);
            if (i >= 3) continue;
            sb.append(".");
            ++i;
        }
        version = sb.toString();
        return version;
    }

    public List<String> getUpgradeScriptPaths(String currVersion) {
        if (currVersion == null) {
            throw new RuntimeException("Error finding upgrade path from unrecognized version.");
        }
        this.logMessage("Getting list of upgrade scripts to be executed as part of database migration from " + currVersion);
        File upgradeRootDir = new File(this.getUpgradeDirPath());
        File[] upgradeDirectories = upgradeRootDir.listFiles();
        if (upgradeDirectories == null || upgradeDirectories.length == 0) {
            return new ArrayList<String>();
        }
        Arrays.sort(upgradeDirectories, this.versionComparator);
        ArrayList<String> paths = new ArrayList<String>();
        double currVersionInt = DatabaseManagementUtils.doubleVersionOf(currVersion);
        boolean addAfter = false;
        for (File file : upgradeDirectories) {
            String[] folderNameParts = file.getName().split("-to-");
            double toVersionLong = DatabaseManagementUtils.doubleVersionOf(folderNameParts[1].trim().replace("v", ""));
            double fromVersionLong = DatabaseManagementUtils.doubleVersionOf(folderNameParts[0].trim().replace("v", ""));
            if (!addAfter && (currVersionInt >= fromVersionLong && currVersionInt < toVersionLong || currVersionInt < fromVersionLong)) {
                addAfter = true;
            }
            if (!addAfter) continue;
            paths.add(file.getAbsolutePath() + File.separator + "migration.sql");
            this.logMessage("Adding migration file " + file.getAbsolutePath() + File.separator + "migration.sql to list of migration files to execute.");
        }
        if (paths.isEmpty()) {
            String lastVersionFound = upgradeDirectories[upgradeDirectories.length - 1].getName().replaceAll("/D", "");
            String minorVersion = currVersion.substring(0, 5);
            this.logMessage("No sql migration was found to apply. Verifying that your version, " + minorVersion + ", is covered by sql version " + lastVersionFound);
            if (lastVersionFound.contains(minorVersion)) {
                this.logMessage("Check passed. No sql migration needed.");
            } else {
                throw new RuntimeException("Unable to get find a sql upgrade path from version " + currVersion + " to the version you are upgrading to. The installer only supports upgrading from version 5.0.0.0 or higher at this time.");
            }
        }
        return paths;
    }

    static double doubleVersionOf(String currVersion) {
        double out = 0.0;
        int factor = 3;
        if (currVersion == null) {
            throw new RuntimeException("doubleVersionOf must have a version to parse.");
        }
        String[] parts = currVersion.split("\\.");
        for (int i = parts.length - 1; i >= 0; --i) {
            int part = Integer.parseInt(parts[i]);
            int power = parts.length - i - 1;
            double shift = Math.pow(10.0, factor * power);
            out += (double)part * shift;
        }
        return out;
    }

    public void executeUpgradeScript(File sqlScript) throws SQLException, IOException {
        System.out.println();
        this.logMessage("Executing " + sqlScript.getAbsolutePath());
        try (Connection connection = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());){
            connection.setAutoCommit(true);
            List<String> statements = this.parseSqlFile(sqlScript, connection);
            String lastSuccesfulStatement = null;
            String fdadmin = " to FD_ADMIN";
            Pattern fdadminPattern = Pattern.compile(fdadmin, 2);
            for (String statement : statements) {
                statement = statement.trim();
                Matcher matcher = fdadminPattern.matcher(statement);
                statement = matcher.replaceAll(" to " + this.getLimitedUser());
                if (this.isParameterizedInstallScript(sqlScript.getName()) && this.getSchemaPassword() != null) {
                    this.logMessage("Updating password for parameterized script " + sqlScript.getName());
                    statement = sqlScript.getName().equalsIgnoreCase("createschemas.sql") ? statement.replace("'welcome1'", "'" + this.getSchemaPassword() + "'") : statement.replace("&1", '\"' + this.getSchemaPassword() + '\"');
                }
                try {
                    Statement stmt = connection.createStatement();
                    try {
                        stmt.setEscapeProcessing(false);
                        if (this.isSqlPlusCommand(statement)) {
                            this.logMessage("Ignoring " + statement + " as it is a sql plus command");
                            continue;
                        }
                        try {
                            this.logMessage(statement);
                            stmt.execute(statement);
                            lastSuccesfulStatement = statement;
                        }
                        catch (SQLException e) {
                            this.logError("Exception occurred while executing " + sqlScript.getAbsolutePath());
                            if (lastSuccesfulStatement != null) {
                                this.logError("Last successful statement executed: " + lastSuccesfulStatement);
                            }
                            this.logError("Script execution failed on statement: " + statement);
                            throw e;
                        }
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    this.logError("Exception occurred while creating SQL statement " + statement);
                    throw e;
                }
            }
            this.logMessage("Successfully executed " + sqlScript.getAbsolutePath());
            System.out.println();
        }
    }

    private boolean isSqlPlusCommand(String statement) {
        return statement.equalsIgnoreCase("set define off") || statement.equalsIgnoreCase("set echo on") || statement.equalsIgnoreCase("spool");
    }

    private boolean isParameterizedInstallScript(String fileName) {
        return fileName.equalsIgnoreCase("createff.sql") || fileName.equalsIgnoreCase("createfd.sql") || fileName.equalsIgnoreCase("fdoraclegenerateprocedures.sql") || fileName.equalsIgnoreCase("createschemas.sql");
    }

    private List<String> parseSqlFile(String sqlFileName, Connection connection) throws IOException {
        this.logMessage("Parsing " + sqlFileName);
        try (InputStream is = this.getClass().getResourceAsStream(sqlFileName);){
            List<String> list = this.parseSqlFile(is, connection);
            return list;
        }
    }

    private List<String> parseSqlFile(File sqlFile, Connection connection) throws IOException {
        this.logMessage("Parsing " + sqlFile);
        try (InputStream is = Files.newInputStream(sqlFile.toPath(), new OpenOption[0]);){
            List<String> list = this.parseSqlFile(is, connection);
            return list;
        }
    }

    private List<String> parseSqlFile(InputStream sqlFile, Connection connection) throws IOException {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        DbSupport dbSupport = DbSupportFactory.createDbSupport(connection, false);
        List<String> originalFileLines = this.readFileData(sqlFile);
        ArrayList<String> partialFileLines = new ArrayList<String>();
        boolean firstLine = true;
        for (String line : originalFileLines) {
            boolean currentLineIsForwardSlash;
            if (firstLine) {
                line = line.replaceAll("[\\x00-\\x1F\\x80-\\xFF]", "");
                firstLine = false;
            }
            if (currentLineIsForwardSlash = line.trim().equals("/")) {
                List<String> sqlFileLineStatements = this.parseSQLFileLines(partialFileLines, dbSupport);
                sqlStatements.addAll(sqlFileLineStatements);
                partialFileLines = new ArrayList();
                continue;
            }
            partialFileLines.add(line);
        }
        if (!partialFileLines.isEmpty()) {
            List<String> sqlFileLineStatements = this.parseSQLFileLines(partialFileLines, dbSupport);
            sqlStatements.addAll(sqlFileLineStatements);
        }
        return sqlStatements;
    }

    private List<String> parseSQLFileLines(List<String> sqlLines, DbSupport dbSupport) {
        ArrayList<String> sqlStatementStrings = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean isDoing = false;
        for (int lineCounter = 0; lineCounter < sqlLines.size(); ++lineCounter) {
            String nextLine;
            String line = sqlLines.get(lineCounter);
            if (line.trim().equalsIgnoreCase("DO") && (nextLine = sqlLines.get(lineCounter + 1)).trim().equals("$$")) {
                isDoing = true;
                sb.append("DO $$");
                ++lineCounter;
                continue;
            }
            if (isDoing && line.trim().equalsIgnoreCase("$$")) {
                line = "$$;";
                isDoing = false;
            }
            sb.append(line);
            sb.append("\n");
        }
        SqlScript s2 = new SqlScript(sb.toString(), dbSupport);
        List<SqlStatement> statements = s2.getSqlStatements();
        for (SqlStatement statement : statements) {
            sqlStatementStrings.add(statement.getSql());
        }
        return sqlStatementStrings;
    }

    private List<String> readFileData(InputStream sqlFile) throws IOException {
        ArrayList<String> data = new ArrayList<String>();
        try (InputStreamReader isr = new InputStreamReader(sqlFile);
             BufferedReader bfr = new BufferedReader(isr);){
            String line = bfr.readLine();
            while (line != null) {
                data.add(line);
                line = bfr.readLine();
            }
        }
        catch (FileNotFoundException e) {
            this.logError("Export/Import file not found");
            throw e;
        }
        return data;
    }

    public void updateCSSVersion(String version) throws SQLException {
        if (version == null || version.isEmpty()) {
            version = this.getCSSVersionForLastMigrationFile();
        }
        this.logMessage("Updating version in CSS_VERSION table to match installed version " + version);
        try (Connection con = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
             PreparedStatement stmt = con.prepareStatement("insert into CSS.CSS_VERSION values(?,current_date,'SYSTEM',current_date,'SYSTEM',1)");){
            stmt.setString(1, version);
            con.setAutoCommit(true);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logError("Exception occurred while trying to update version in FD_CSS_VERSION table to match installed version " + version);
            throw e;
        }
    }

    String getCSSVersionForLastMigrationFile() {
        File upgradeRootDir = new File(this.getUpgradeDirPath());
        if (!upgradeRootDir.exists()) {
            return "10.0.0.0";
        }
        File[] upgradeDirectories = upgradeRootDir.listFiles();
        if (upgradeDirectories == null) {
            throw new RuntimeException("Unable to list files in folder " + upgradeRootDir + " Perhaps the zip is corrupt, permissions were wrong on that folder, or a setting is wrong. Verify the user that is running the installer owns the download and temp folders recursively.");
        }
        Arrays.sort(upgradeDirectories, this.versionComparator);
        return upgradeDirectories[upgradeDirectories.length - 1].getName().split("-to-v?")[1];
    }

    public void validateConnection() throws SQLException, IllegalArgumentException {
        try (Connection con = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
             Statement stmt = con.createStatement();){
            if (this.isOracle()) {
                stmt.executeQuery("SELECT * from DUAL");
            } else if (this.isPostgres()) {
                stmt.executeQuery("SELECT 1");
            }
            this.logMessage("Connection valid");
        }
        catch (SQLException e) {
            this.logError("Exception occurred while validating connection " + this.getURL());
            if (e.getMessage().contains("password authentication failed") || e.getMessage().contains("invalid username/password")) {
                this.logError("Username or password is incorrect.");
                throw e;
            }
            e.printStackTrace();
            throw new IllegalArgumentException("URL or port is incorrect.");
        }
    }

    public void backupDB(String schemaName, String currentDBVersion) throws SQLException, IOException, InterruptedException {
        block77: {
            if (this.isOracle()) {
                List<String> statements;
                Connection connection;
                if (this.getExportDirectory() == null) {
                    this.setExportDirectory("DATA_PUMP_DIR");
                }
                if (!this.checkOracleDBADirectoryExists()) {
                    this.logError(this.getExportDirectory() + " is not located in the DBA_Directories table. Ensure that the directory is added to DBA_DIRECTORIES and file system path is created on the DB server.");
                    throw new SQLException(this.getExportDirectory() + " is not located in the DBA_Directories table. Ensure that the directory is added to DBA_DIRECTORIES and file system path is created on the DB server.");
                }
                String backupFileName = schemaName + currentDBVersion + ".dmp";
                boolean backupExists = false;
                try {
                    connection = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
                    try {
                        connection.setAutoCommit(true);
                        statements = this.parseSqlFile("/scripts/backupExistCheck.sql", connection);
                        for (String statement : statements) {
                            statement = statement.trim();
                            PreparedStatement backupSchemaStmt = connection.prepareStatement(statement);
                            try {
                                backupSchemaStmt.setString(1, backupFileName);
                                backupSchemaStmt.setString(2, this.getExportDirectory());
                                if (this.isSqlPlusCommand(statement)) continue;
                                backupSchemaStmt.execute();
                            }
                            finally {
                                if (backupSchemaStmt == null) continue;
                                backupSchemaStmt.close();
                            }
                        }
                        this.logMessage("Backup found for " + backupFileName + " in " + this.getExportDirectory() + " directory.");
                        backupExists = true;
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    this.logMessage("No backup found for " + backupFileName);
                    backupExists = false;
                }
                if (backupExists) {
                    this.logMessage("Backup for version " + currentDBVersion + "(" + backupFileName + ") already exists in " + this.getExportDirectory() + " directory. Skipping backup.");
                    return;
                }
                try {
                    connection = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
                    try {
                        connection.setAutoCommit(true);
                        statements = this.parseSqlFile("/scripts/export.sql", connection);
                        this.logMessage("Executing backup for oracle database: Schema Name - " + schemaName.toUpperCase() + ", Export Directory Name - " + this.getExportDirectory() + ", Dump File Name - " + backupFileName);
                        for (String statement : statements) {
                            statement = statement.trim();
                            PreparedStatement stmt = connection.prepareStatement(statement);
                            try {
                                stmt.setEscapeProcessing(true);
                                stmt.setString(1, schemaName.toUpperCase());
                                stmt.setString(2, this.getExportDirectory());
                                stmt.setString(3, backupFileName);
                                if (this.isSqlPlusCommand(statement)) continue;
                                stmt.execute();
                            }
                            finally {
                                if (stmt == null) continue;
                                stmt.close();
                            }
                        }
                        this.logMessage("Completed backup of " + schemaName + " to " + this.getExportDirectory() + File.separator + backupFileName);
                        break block77;
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (IOException | SQLException e) {
                    this.logError("Exception occurred while executing DB backup.");
                    throw e;
                }
            }
            if (this.isPostgres()) {
                Connection connection;
                boolean exportDirectoryArgEmpty;
                schemaName = schemaName.toLowerCase();
                boolean bl = exportDirectoryArgEmpty = this.getExportDirectory() == null || this.getExportDirectory().trim().isEmpty();
                if (this.isPostgresInstalled() && !exportDirectoryArgEmpty) {
                    this.logMessage("Backing up to directory " + this.getExportDirectory());
                    String backupFileName = schemaName + currentDBVersion;
                    File backupFile = new File(this.getExportDirectory() + File.separator + backupFileName);
                    if (backupFile.exists()) {
                        this.logMessage("Backup for version " + currentDBVersion + " already exists at " + this.getExportDirectory() + File.separator + backupFileName + ". Skipping backup.");
                        return;
                    }
                    this.logMessage("Executing backup for " + schemaName);
                    try {
                        this.logMessage("Executing backup for Postgres database: Host - " + this.getHost() + ", Port - " + this.getPort() + ", Schema Name - " + schemaName + ", User - " + this.getUsername() + ", PG Dump Directory - " + this.getExportDirectory() + File.separator + backupFileName);
                        new File(this.getExportDirectory() + File.separator + backupFileName).mkdirs();
                        ProcessBuilder pb = new ProcessBuilder("pg_dump", "--host", this.getHost(), "--port", this.getPort(), "--schema", schemaName, "--username", this.getUsername(), "--no-password", "--verbose", "--format", "d", "--file", this.getExportDirectory() + File.separator + backupFileName, this.getDatabaseName());
                        pb.environment().put("PGPASSWORD", this.getPassword());
                        Process p = pb.start();
                        BufferedReader r = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        String line = r.readLine();
                        while (line != null) {
                            this.logError(line);
                            line = r.readLine();
                        }
                        r.close();
                        p.waitFor();
                        this.logMessage("Completed backup of " + schemaName + " to " + this.getExportDirectory() + File.separator + backupFileName);
                    }
                    catch (IOException | InterruptedException e) {
                        this.logError("Exception occurred while executing DB backup");
                        throw e;
                    }
                }
                schemaName = schemaName.toLowerCase();
                String backupSchemaName = schemaName + "_" + currentDBVersion.replace(".", "_") + "_bak";
                try {
                    connection = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
                    try (Statement backupCheckStatement = connection.createStatement();){
                        ResultSet backupCheckResultSet = backupCheckStatement.executeQuery("select schema_name from information_schema.schemata where schema_name like '%" + backupSchemaName + "%'");
                        if (backupCheckResultSet.next()) {
                            this.logMessage("Backup schema for version " + currentDBVersion + " already exists " + backupSchemaName + ". Skipping backup.");
                            return;
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    this.logError("Exception occurred while checking if backup schema " + backupSchemaName + " exists. ");
                    throw e;
                }
                this.logMessage("Executing backup Postgres database: URL - " + this.getURL() + ", Username - " + this.getUsername() + ", Schema Name - " + schemaName + ", Backup Schema Name - " + backupSchemaName);
                try {
                    connection = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
                    try (Statement backupStatement = connection.createStatement();){
                        connection.setAutoCommit(true);
                        ResultSet functionResultSet = backupStatement.executeQuery("select proname from pg_catalog.pg_proc p where proname='clone_schema'");
                        if (!functionResultSet.next()) {
                            List<String> statements = this.parseSqlFile("/scripts/cloneSchemaPostgres.sql", connection);
                            for (String statement : statements) {
                                statement = statement.trim();
                                try (PreparedStatement stmt = connection.prepareStatement(statement);){
                                    if (this.isSqlPlusCommand(statement)) continue;
                                    stmt.execute();
                                }
                            }
                        }
                        backupStatement.execute("select clone_schema('" + schemaName + "','" + backupSchemaName + "' ,true, false)");
                        this.logMessage("Completed backup of " + schemaName + " to new schema " + backupSchemaName);
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (IOException | SQLException e) {
                    this.logError("Exception occurred while executing DB backup");
                    throw e;
                }
            }
        }
    }

    public void revertFromBackup(String schemaName) throws SQLException, IOException, InterruptedException {
        this.revertFromBackup(schemaName, null);
    }

    public void revertFromBackup(String schemaName, String revertVersion) throws SQLException, IOException, InterruptedException {
        block37: {
            if (revertVersion == null && (revertVersion = this.getRevertVersion(schemaName)) == null) {
                this.logError("No backup found for " + schemaName);
                throw new SQLException("Unable to find backup for schema " + schemaName + " in directory " + this.getExportDirectory());
            }
            if (this.getDBType().equalsIgnoreCase("oracle")) {
                String backupFileName = schemaName + revertVersion + ".dmp";
                this.logMessage("Reverting from backup for Oracle database: Schema Name - " + schemaName);
                try (Connection connection = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());){
                    connection.setAutoCommit(true);
                    List<String> statements = this.parseSqlFile("/scripts/import.sql", connection);
                    for (String statement : statements) {
                        statement = statement.trim();
                        PreparedStatement stmt = connection.prepareStatement(statement);
                        try {
                            stmt.setString(1, schemaName.toUpperCase());
                            stmt.setString(2, this.getExportDirectory());
                            stmt.setString(3, backupFileName);
                            if (this.isSqlPlusCommand(statement)) continue;
                            stmt.execute();
                        }
                        finally {
                            if (stmt == null) continue;
                            stmt.close();
                        }
                    }
                    this.logMessage("Revert from backup for " + schemaName + " from " + this.getExportDirectory() + File.separator + backupFileName + " completed");
                    break block37;
                }
                catch (IOException | SQLException e) {
                    this.logError("Exception occurred while executing DB revert");
                    throw e;
                }
            }
            if (this.getDBType().equalsIgnoreCase("postgres")) {
                schemaName = schemaName.toLowerCase();
                this.logMessage("Reverting from backup for Postgres database: Schema Name - " + schemaName);
                if (this.isPostgresInstalled() && this.getExportDirectory() != null && !this.getExportDirectory().isEmpty()) {
                    String backupFileName = schemaName + revertVersion;
                    try {
                        ProcessBuilder pb = new ProcessBuilder("pg_restore", "--host", this.getHost(), "--port", this.getPort(), "--dbname", this.getDatabaseName(), "--clean", "--username", this.getUsername(), "--verbose", this.getExportDirectory() + File.separator + backupFileName);
                        pb.environment().put("PGPASSWORD", this.getPassword());
                        Process p = pb.start();
                        BufferedReader r = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        String line = r.readLine();
                        while (line != null) {
                            this.logError(line);
                            line = r.readLine();
                        }
                        r.close();
                        p.waitFor();
                    }
                    catch (IOException | InterruptedException e) {
                        this.logError("Exception occurred while executing DB backup");
                        throw e;
                    }
                }
                this.logMessage("Reverting from backup for Postgres database: Schema Name - " + schemaName);
                String backupSchemaName = schemaName + "_" + revertVersion + "_bak";
                try (Connection connection = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
                     Statement stmt = connection.createStatement();){
                    ResultSet backupSchemaCheckResultSet = stmt.executeQuery("select schema_name from information_schema.schemata where schema_name like '%" + backupSchemaName + "%'");
                    if (backupSchemaCheckResultSet.next()) {
                        backupSchemaName = backupSchemaCheckResultSet.getString(1);
                        stmt.execute("drop schema " + schemaName + " cascade");
                        stmt.execute("alter schema " + backupSchemaName + " rename to " + schemaName);
                    } else {
                        this.logError("No backup schema was found for " + schemaName);
                    }
                    this.logMessage("Revert from backup for " + schemaName + " from " + backupSchemaName + " completed");
                }
                catch (SQLException e) {
                    this.logError("Exception occurred while executing DB revert");
                    throw e;
                }
            }
        }
    }

    public String getRevertVersion(String schemaName) throws SQLException {
        String revertVersion = null;
        if (this.getDBType().equalsIgnoreCase("postgres")) {
            schemaName = schemaName.toLowerCase();
            if (this.isPostgresInstalled() && this.getExportDirectory() != null && !this.getExportDirectory().isEmpty()) {
                File exportDir = new File(this.getExportDirectory());
                List<String> files = Arrays.asList(Objects.requireNonNull(exportDir.list((current, name) -> new File(current, name).isDirectory())));
                files.sort(Collections.reverseOrder());
                for (String file : files) {
                    Pattern backupPattern = Pattern.compile(schemaName + ".*[0-9]\\.[0-9]\\.[0-9]\\.[0-9]");
                    Matcher matcher = backupPattern.matcher(file.toLowerCase());
                    if (!matcher.matches()) continue;
                    revertVersion = file.toLowerCase().replaceAll(schemaName, "");
                    break;
                }
            } else {
                try (Connection connection = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
                     Statement stmt = connection.createStatement();){
                    ResultSet backupSchemaCheckResultSet = stmt.executeQuery("select schema_name from information_schema.schemata where schema_name like '%" + schemaName + "%_bak%' order by schema_name desc");
                    if (backupSchemaCheckResultSet.next()) {
                        String backupSchemaName = backupSchemaCheckResultSet.getString(1);
                        revertVersion = backupSchemaName.replace(schemaName + "_", "").replace("_bak", "");
                    }
                }
                catch (SQLException e) {
                    this.logError("Error occurred while finding latest backup version.");
                    throw e;
                }
            }
        }
        return revertVersion;
    }

    public boolean isPostgresInstalled() {
        boolean installed = true;
        try {
            Runtime.getRuntime().exec("psql --version");
        }
        catch (IOException e) {
            installed = false;
        }
        return installed;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String newURL) {
        this.url = newURL;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String newUsername) {
        this.username = newUsername;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public String getDBType() {
        if (this.dbType == null && this.url != null) {
            String[] urlElements = this.url.split(":");
            this.dbType = urlElements[1];
            if (this.dbType.equalsIgnoreCase("postgresql")) {
                this.dbType = "postgres";
            }
            this.logMessage("Found Database type " + this.dbType);
        }
        return this.dbType;
    }

    public String getUpgradeDirPath() {
        return this.upgradeDirPath;
    }

    public void setUpgradeDirPath(String newUpgradeDirPath) {
        this.upgradeDirPath = newUpgradeDirPath;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String newLogFilePath) {
        this.logFilePath = newLogFilePath;
    }

    public String getSchemaPassword() {
        return this.schemaPassword;
    }

    public void setSchemaPassword(String newSchemaPassword) {
        this.schemaPassword = newSchemaPassword;
    }

    public String getPrereqUserType() {
        return this.prereqUserType;
    }

    public void setPrereqUserType(String newPrereqUserType) {
        this.prereqUserType = newPrereqUserType;
    }

    public String getExportDirectory() {
        return this.exportDirectory;
    }

    public void setLimitedUser(String newLimitedUser) {
        this.limitedUser = newLimitedUser;
    }

    public String getLimitedUser() {
        return this.limitedUser;
    }

    public void setExportDirectory(String newExportDirectory) {
        this.exportDirectory = newExportDirectory;
    }

    private void logError(String message) {
        if (message != null) {
            message = this.hideSensitiveInformation(message);
            System.err.println(DTF.format(LocalDateTime.now()) + " - " + message);
        }
    }

    private void logMessage(String message) {
        if (message != null) {
            message = this.hideSensitiveInformation(message);
            System.out.println(DTF.format(LocalDateTime.now()) + " - " + message);
        }
    }

    public String hideSensitiveInformation(String message) {
        if (this.getSchemaPassword() != null) {
            message = message.replace(this.getSchemaPassword(), "*****");
        }
        if (this.getPassword() != null) {
            message = message.replace(this.getPassword(), "****");
        }
        return message;
    }

    public boolean isOracle() {
        return "oracle".equalsIgnoreCase(this.getDBType());
    }

    public boolean isPostgres() {
        return "postgres".equalsIgnoreCase(this.getDBType());
    }

    private void registerDriver() throws SQLException {
        block4: {
            try {
                if (this.isOracle()) {
                    DriverManager.registerDriver((java.sql.Driver)new OracleDriver());
                    break block4;
                }
                if (this.isPostgres()) {
                    DriverManager.registerDriver(new Driver());
                    break block4;
                }
                this.logError("Unknown Database type " + this.getDBType());
                throw new RuntimeException("Unknown Database type " + this.getDBType());
            }
            catch (SQLException e) {
                this.logError("Exception occurred while registering driver for " + this.getDBType());
                throw e;
            }
        }
    }

    public String getHost() {
        if (this.host == null) {
            this.parseURL();
        }
        return this.host;
    }

    public void setHost(String newHost) {
        this.host = newHost;
    }

    public String getPort() {
        if (this.port == null) {
            this.parseURL();
        }
        return this.port;
    }

    public void setPort(String newPort) {
        this.port = newPort;
    }

    public String getDatabaseName() {
        if (this.databaseName == null) {
            this.parseURL();
        }
        return this.databaseName;
    }

    private void setDatabaseName(String newDatabaseName) {
        this.databaseName = newDatabaseName;
    }

    private void parseURL() {
        if (this.url != null && this.isPostgres()) {
            String[] urlParts = this.url.split("//");
            String[] hostPortDatabase = urlParts[1].split("/");
            String[] hostPort = hostPortDatabase[0].split(":");
            this.setHost(hostPort[0]);
            if (hostPort.length > 1) {
                this.setPort(hostPort[1]);
            }
            if (hostPortDatabase.length > 1) {
                this.setDatabaseName(hostPortDatabase[1]);
            }
        }
        this.logMessage("Host: " + this.getHost() + " Port: " + this.getPort() + " Database Name: " + this.getDatabaseName());
    }

    public void logBackupInformation(String schemaName, LocalDateTime backupDateTime, String currentVersion) throws IOException {
        DateTimeFormatter fileFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        String logDir = new File(this.logFilePath).getParent();
        File dbBackupInfoFile = new File(logDir + File.separator + "dbBackupInfo_" + backupDateTime.format(fileFormatter) + ".txt");
        String backupFileLocation = this.getBackupFileLocation(schemaName, currentVersion);
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(dbBackupInfoFile, true));){
            writer.println("Schema Name: " + schemaName);
            writer.println("Database Backup Location: " + backupFileLocation);
            writer.println("Database Type: " + this.getDBType());
            writer.println("Backup Date: " + backupDateTime);
            writer.println();
        }
    }

    private String getBackupFileLocation(String schemaName, String currentVersion) {
        String backupFileLocation = "";
        backupFileLocation = this.isOracle() ? this.getExportDirectory() + File.separator + schemaName + currentVersion + ".dmp" : (this.isPostgresInstalled() && this.getExportDirectory() != null && !this.getExportDirectory().isEmpty() ? this.getExportDirectory() + File.separator + schemaName + currentVersion : "Schema - " + schemaName + currentVersion.replace(".", "_") + "_bak");
        return backupFileLocation;
    }

    public boolean checkOracleDBADirectoryExists() throws SQLException {
        boolean exists = false;
        if (this.isOracle() && this.getExportDirectory() != null && "SYSTEM".equals(this.getPrereqUserType())) {
            try (Connection con = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
                 PreparedStatement stmt = con.prepareStatement("SELECT DIRECTORY_PATH from DBA_DIRECTORIES where directory_name=?");){
                stmt.setString(1, this.getExportDirectory());
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        exists = true;
                        rs.getString(1);
                    } else {
                        this.logError("No entries found for: SELECT DIRECTORY_PATH from dba_directories where directory_name='" + this.getExportDirectory() + "'");
                    }
                }
            }
            catch (SQLException e) {
                this.logError("Exception occurred while executing SQL script to check if Directory name " + this.getExportDirectory() + " exists in DBA_DIRECTORIES table");
                e.printStackTrace();
            }
        } else {
            exists = true;
        }
        return exists;
    }

    public boolean checkDBUserPermissions() {
        boolean isSuperUser = false;
        if (this.isPostgres() && "SYSTEM".equals(this.getPrereqUserType())) {
            try (Connection con = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
                 PreparedStatement stmt = con.prepareStatement("SELECT usename FROM PG_USER WHERE (usesuper='true' or usecreatedb='true') AND usename = ?");){
                stmt.setString(1, this.getUsername());
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    isSuperUser = true;
                }
            }
            catch (SQLException e) {
                this.logError("Exception occurred while executing SQL script to check if user " + this.getUsername() + " has correct permissions.");
                e.printStackTrace();
            }
        } else {
            isSuperUser = true;
        }
        return isSuperUser;
    }

    public boolean schemaExists(String schema) {
        boolean exist = false;
        try (Connection con = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
             PreparedStatement stmt = con.prepareStatement(this.isOracle() ? "SELECT 1 FROM all_users WHERE UPPER(username) = UPPER(?)" : "SELECT 1 FROM information_schema.schemata WHERE LOWER(schema_name) = LOWER(?)");){
            stmt.setString(1, schema);
            try (ResultSet rs = stmt.executeQuery();){
                exist = rs.next();
            }
        }
        catch (SQLException e) {
            this.logError("Exception occurred while checking if schema " + schema + " exists.");
            e.printStackTrace();
        }
        return exist;
    }
}

