/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.phoenix;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.dbsupport.phoenix.PhoenixSchema;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class PhoenixDbSupport
extends DbSupport {
    private static final Log LOG = LogFactory.getLog(PhoenixDbSupport.class);

    public PhoenixDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 12));
    }

    @Override
    public String getDbName() {
        return "phoenix";
    }

    @Override
    public Schema getOriginalSchema() {
        return this.getSchema(this.originalSchema);
    }

    @Override
    public String quote(String ... identifiers) {
        String result = "";
        boolean first = true;
        boolean lastNull = false;
        for (String identifier : identifiers) {
            if (!first && !lastNull) {
                result = result + ".";
            }
            first = false;
            if (identifier == null) {
                lastNull = true;
                continue;
            }
            result = result + this.doQuote(identifier);
            lastNull = false;
        }
        return result;
    }

    @Override
    protected String doGetCurrentSchemaName() throws SQLException {
        return null;
    }

    @Override
    public void changeCurrentSchemaTo(Schema schema) {
        LOG.info("Phoenix does not support setting the schema. Default schema NOT changed to " + schema);
    }

    @Override
    protected void doChangeCurrentSchemaTo(String schema) throws SQLException {
        LOG.info("Phoenix does not support setting the schema. Default schema NOT changed to " + schema);
    }

    @Override
    public String getCurrentUserFunction() {
        try {
            return this.jdbcTemplate.getMetaData().getUserName();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new SqlStatementBuilder();
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public Schema getSchema(String name) {
        return new PhoenixSchema(this.jdbcTemplate, this, name);
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

