/*
 * Decompiled with CFR 0.152.
 */
package flexagon.css.installer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class FlexLogFormatter
extends SimpleFormatter {
    private static final String LINESEP = System.getProperty("line.separator");
    private static final String ZERO = "";
    private static final String ONE = " ";
    private static final String TWO = "  ";
    private static final String THREE = "   ";
    private static final String FOUR = "    ";
    private static final String FIVE = "     ";
    private static final String SIX = "      ";

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append(new Date(record.getMillis()));
        sb.append(" - ");
        sb.append(this.leftpad(Thread.currentThread().getId() + ZERO, 4));
        sb.append(" - ");
        sb.append(this.leftpad(record.getLevel() + ZERO, 7));
        sb.append(" - ");
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName());
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(".");
            sb.append(record.getSourceMethodName());
        }
        String message = this.formatMessage(record);
        sb.append(" - ");
        sb.append(message);
        sb.append(LINESEP);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private String leftpad(String pString, int pTotal) {
        if (pString != null) {
            int length = pString.length();
            int pad = pTotal - length;
            return this.spaces(pad) + pString;
        }
        return null;
    }

    private String spaces(int total) {
        if (total <= 0) {
            return ZERO;
        }
        if (total == 1) {
            return ONE;
        }
        if (total == 2) {
            return TWO;
        }
        if (total == 3) {
            return THREE;
        }
        if (total == 4) {
            return FOUR;
        }
        if (total == 5) {
            return FIVE;
        }
        return SIX;
    }
}

