/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.sybase.ase;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.dbsupport.sybase.ase.SybaseASESchema;
import org.flywaydb.core.internal.dbsupport.sybase.ase.SybaseASESqlStatementBuilder;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class SybaseASEDbSupport
extends DbSupport {
    private static final Log LOG = LogFactory.getLog(SybaseASEDbSupport.class);

    public SybaseASEDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 0));
    }

    @Override
    public Schema getSchema(String name) {
        SybaseASESchema schema = new SybaseASESchema(this.jdbcTemplate, this, name){

            @Override
            protected boolean doExists() throws SQLException {
                return false;
            }
        };
        try {
            String currentName = this.doGetCurrentSchemaName();
            if (currentName.equals(name)) {
                schema = new SybaseASESchema(this.jdbcTemplate, this, name);
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to obtain current schema, return non-existing schema", e);
        }
        return schema;
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new SybaseASESqlStatementBuilder();
    }

    @Override
    public String getDbName() {
        return "sybaseASE";
    }

    @Override
    protected String doGetCurrentSchemaName() throws SQLException {
        return this.jdbcTemplate.queryForString("select USER_NAME()", new String[0]);
    }

    @Override
    protected void doChangeCurrentSchemaTo(String schema) throws SQLException {
        LOG.info("Sybase does not support setting the schema for the current session. Default schema NOT changed to " + schema);
    }

    @Override
    public String getCurrentUserFunction() {
        return "user_name()";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    protected String doQuote(String identifier) {
        return identifier;
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

