#!/bin/bash 

# software download
LATEST_VERSION_URL=https://flexagon.com/downloads/configsnapshot/Tomcat/current_version.php
CSS_SOFTWARE_DOWNLOAD_URL=https://flexagon.com/downloads/configsnapshot/Tomcat
CSS_ALT_SOFTWARE_DOWNLOAD_URL=https://flexagon.com/downloads/configsnapshot/CSS-${DESIRED_VERSION}.zip

# minimum file system sizes in MB
MIN_WORKING_DIRECTORY_SIZE=10000
MIN_ARTIFACT_REPO_DIRECTORY_SIZE=10000
MIN_UPGRADE_BACKUP_DIRECTORY_SIZE=1000
MIN_BACKUP_DATABASE_DIRECTORY_SIZE=10000

# size factor adjustment if running a POV, all minimum file system sizes will be adjusted by this factor
DIRECTORY_SIZE_FACTOR=.5

# max time to wait before killing the tomcat server in seconds
MAX_TIME_TO_WAIT_FOR_STOP=30
STOP_WAIT_TIME=2

# for error message
WARN=0
EXIT=1

# for different modes
STANDARD=0
POV=1

# install state
INSTALL=0
UPGRADE=1
UPGRADE_FROM_WLS=2

INSTALLER_DOWNLOADS_DIRECTORY=${CSS_INSTALLER_HOME}/../downloads
INSTALLER_DOWNLOADS_SOFTWARE_DIRECTORY=${INSTALLER_DOWNLOADS_DIRECTORY}/software
INSTALLER_DOWNLOADS_WALLETS_DIRECTORY=${INSTALLER_DOWNLOADS_DIRECTORY}/wallets

INSTALLER_TEMP_DIRECTORY=${CSS_INSTALLER_HOME}/../temp
INSTALLER_TEMP_SOFTWARE_DIRECTORY=${INSTALLER_TEMP_DIRECTORY}/software
INSTALLER_TEMP_CONFIG_DIRECTORY=${INSTALLER_TEMP_DIRECTORY}/config
INSTALLER_TEMP_DRIVER_DIRECTORY=${INSTALLER_TEMP_DIRECTORY}/driver
INSTALLER_TEMP_SOFTWARE_PLUGINS_DIRECTORY=${INSTALLER_TEMP_SOFTWARE_DIRECTORY}/application/plugins

METAINF=META-INF
METAINF_MANIFEST_MF=${METAINF}/MANIFEST.MF
TOMCAT_COMPLETE_ZIP_FILE_NAME=css.zip
TOMCAT_SERVER_XML=server.xml
TOMCAT_CONTEXT_XML=context.xml
CONTEXT_XML_ORACLE=context-oracle.xml
CONTEXT_XML_POSTGRES=context-postgresql.xml
APACHE_TOMCAT_CSS=apache-tomcat-css
APACHE_TOMCAT_CSS_LIB=${APACHE_TOMCAT_CSS}/lib
APACHE_TOMCAT_CSS_LIBEXT=${APACHE_TOMCAT_CSS}/libext
APACHE_TOMCAT_CSS_CONF=${APACHE_TOMCAT_CSS}/conf
APACHE_TOMCAT_CSS_LOGS=${APACHE_TOMCAT_CSS}/logs
APACHE_TOMCAT_CSS_WEBAPPS=${APACHE_TOMCAT_CSS}/webapps
APACHE_TOMCAT_CSS_BIN=${APACHE_TOMCAT_CSS}/bin
APACHE_TOMCAT_CSS_WEBAPPS_CSS_WAR=${APACHE_TOMCAT_CSS_WEBAPPS}/css.war
CSS_DATABASE_WALLET_DIRECTORY=${CSS_HOME}/.wallets
CSS_SSO_DIRECTORY=${CSS_HOME}/.sso

UPGRADE_BASE_DIRECTORY=${CSS_HOME}/upgrade

LOG_DIRECTORY=${UPGRADE_BASE_DIRECTORY}/logs
LOG_FILE=${LOG_DIRECTORY}/log-$(date +"%y-%m-%d_%H-%M-%S").txt
LOG_DATA_FILE=${LOG_DIRECTORY}/logData.txt

SETENV_FILE_NAME=setenv.sh
SETENVOVERRIDE_FILE_NAME=setenvoverride.sh
CSS_TOMCAT_BIN_DIRECTORY=${CSS_HOME}/${APACHE_TOMCAT_CSS_BIN}

if [ "X${CSS_DB_USER}" = "X" ]
then
  CSS_DB_USER=fd_admin
fi
# this classpath uses the unzipped ojdbc8.jar as the prerequisites are prior to any content being layed down so instead of laying it down too early, just use this for the connection test only
DB_UTIL_CLASSPATH=${CSS_INSTALLER_HOME}/scripts/jars/DatabaseManagement.jar:${INSTALLER_TEMP_DRIVER_DIRECTORY}/ojdbc8-full/*

SKIP_PLUGIN_SIZE_CHECK=0
SKIP_ARTIFACT_SIZE_CHECK=0
LATEST_VERSION=0
