DECLARE
  schemaname        VARCHAR2(200) := ?;
  directoryvariable VARCHAR2(100) := ?;
  dumpfilename      VARCHAR2(200) := ?;
                     
  handle            NUMBER;
  status            VARCHAR2(20);
BEGIN
 
  handle := DBMS_DATAPUMP.OPEN(
    operation => 'IMPORT',
    job_mode  => 'SCHEMA',
    job_name  => 'datapump import schema '
                 || schemaname);
 
  DBMS_DATAPUMP.ADD_FILE(
    handle    => handle,
    filename  => dumpfilename,
    directory => directoryvariable);
 
  DBMS_DATAPUMP.ADD_FILE(
    handle    => handle,
    filename  => dumpfilename || '.import.log',
    directory => directoryvariable,
    filetype  => DBMS_DATAPUMP.KU$_FILE_TYPE_LOG_FILE,
    reusefile => 1);
 
  DBMS_DATAPUMP.SET_PARAMETER(
    handle => handle,
    name   => 'table_exists_action',
    value  => 'REPLACE');
 
  DBMS_DATAPUMP.METADATA_FILTER(
    handle => handle,
    name   => 'SCHEMA_EXPR',
    value  => 'IN (''' || schemaname || ''')');
 
  DBMS_DATAPUMP.START_JOB(handle);
  DBMS_DATAPUMP.WAIT_FOR_JOB(handle, status);
  
END;