DECLARE
  schemaname    VARCHAR2(200) := ?;
  directoryvariable VARCHAR2(100) := ?;
  dumpfilename  VARCHAR2(200) := ?;

  handle            NUMBER;
  status            VARCHAR2(20);
BEGIN

  handle := DBMS_DATAPUMP.OPEN(
    operation => 'EXPORT',
    job_mode  => 'SCHEMA',
    job_name  => 'datapump_export_schema_'
                 || schemaname);


  DBMS_DATAPUMP.ADD_FILE(
    handle    => handle,
    filename  => dumpfilename,
    directory => directoryvariable,
    reusefile => 1);


  DBMS_DATAPUMP.ADD_FILE(
    handle    => handle,
    filename  => dumpfilename || '.export.log',
    directory => directoryvariable,
    filetype  => DBMS_DATAPUMP.KU$_FILE_TYPE_LOG_FILE,
    reusefile => 1);

  DBMS_DATAPUMP.METADATA_FILTER(
    handle => handle,
    name   => 'SCHEMA_EXPR',
    value  => 'IN (''' || schemaname || ''')');

  DBMS_DATAPUMP.START_JOB(handle);
  DBMS_DATAPUMP.WAIT_FOR_JOB(handle, status);

EXCEPTION
  WHEN OTHERS THEN
    DECLARE
      job_state varchar2(4000);
      status2 ku$_Status;
    BEGIN
      DBMS_DATAPUMP.GET_STATUS(
        handle    => handle,
        mask      => dbms_datapump.KU$_STATUS_JOB_ERROR,
        timeout   => null,
        job_state => job_state,
        status    => status2);

      if SQLCODE = -31634 then
        --need to drop table system.job_name, but not sure we should automate that, and not sure that we send in system user name.
        null;
      else
        DBMS_DATAPUMP.STOP_JOB(handle,1,0);
        DBMS_DATAPUMP.DETACH(handle);
      end if;
        raise_application_error(-20001, status2.error(status2.error.COUNT).errornumber || ': ' || status2.error(status2.error.COUNT).logtext);
    END;

END;
