/*
 * Decompiled with CFR 0.152.
 */
package flexagon.fd.installer;

import flexagon.fd.installer.DatabaseManagementUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.logging.LogManager;

public class DatabaseManagement {
    static String urlArg = null;
    static String dbUsernameArg = null;
    static String dbPasswordArg = null;
    static String installDirArg = null;
    static String logFilePathArg = null;
    static String schemaPasswordArg = null;
    static String backupDirArg = null;
    static String prereqUserTypeArg = null;
    static String revertVersionArg = null;
    static String operationArg = null;
    static String skipBackupArg = "0";
    static String dbType = null;
    static String fdadminUser;
    static String prereqOp;
    static final DateTimeFormatter DTF;
    static DatabaseManagementUtils utils;

    private static void initializeLogging() {
        String configFileName = "/flexagon/fd/installer/flexlogging.properties";
        InputStream configFile = DatabaseManagement.class.getResourceAsStream(configFileName);
        try {
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (Exception ex) {
            System.err.println("WARNING: Could not find logging configuration file");
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            DatabaseManagement.parseArgs(args);
        } else {
            DatabaseManagement.logError("No arguments provided. Please provide arguments.");
            DatabaseManagement.handleException(new IllegalArgumentException(), 1);
        }
        if (logFilePathArg != null) {
            try {
                FileOutputStream fos = new FileOutputStream(logFilePathArg, true);
                PrintStream ps = new PrintStream(fos);
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException e3) {
                DatabaseManagement.handleException(e3, 2);
            }
        }
        try {
            utils = new DatabaseManagementUtils(urlArg);
        }
        catch (Exception e3) {
            DatabaseManagement.handleException(e3, 13);
        }
        dbType = utils.getDBType();
        if (DatabaseManagement.validateArgs()) {
            utils.setUsername(dbUsernameArg);
            utils.setPassword(dbPasswordArg);
            utils.setLogFilePath(logFilePathArg);
            utils.setSchemaPassword(schemaPasswordArg);
            utils.setExportDirectory(backupDirArg);
            utils.setPrereqUserType(prereqUserTypeArg);
            utils.setLimitedUser(fdadminUser);
            String upgradeDirPath = installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "upgrade";
            utils.setUpgradeDirPath(upgradeDirPath);
            if (operationArg.equals("INSTALL")) {
                DatabaseManagement.install();
            } else if (operationArg.equals("UPGRADE")) {
                DatabaseManagement.upgrade();
            } else if (operationArg.equals("BACKUP")) {
                DatabaseManagement.backup();
            } else if (operationArg.equals("REVERT")) {
                DatabaseManagement.revert();
            } else if (operationArg.equals("PREREQ")) {
                DatabaseManagement.prerequisite("1".equals(skipBackupArg), prereqOp);
            }
        } else {
            DatabaseManagement.handleException(new IllegalArgumentException(), 3);
        }
    }

    private static void parseArgs(String[] args) {
        if (args == null) {
            System.err.println("No arguments provided. Unable to continue.");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-URL")) {
                urlArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-DB_USERNAME")) {
                dbUsernameArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-DB_PASSWORD")) {
                dbPasswordArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-INSTALL_DIR")) {
                installDirArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-LOG_FILE")) {
                logFilePathArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-SCHEMA_PASSWORD")) {
                schemaPasswordArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-BACKUP_DIR")) {
                if (i >= args.length - 1) continue;
                backupDirArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-PREREQ_USER_TYPE")) {
                prereqUserTypeArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-REVERT_VERSION")) {
                revertVersionArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-OPERATION")) {
                operationArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-SKIP_BACKUP")) {
                skipBackupArg = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-FD_ADMIN")) {
                fdadminUser = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-PREREQ_OP")) {
                prereqOp = args[++i];
                continue;
            }
            System.err.println("Ignoring argument " + args[i]);
        }
    }

    private static boolean validateArgs() {
        StringBuilder invalidArguments = new StringBuilder();
        if ("INSTALL".equalsIgnoreCase(operationArg)) {
            if (DatabaseManagement.isBlank(installDirArg)) {
                invalidArguments.append("Install directory is required for " + operationArg + ".\n");
            }
            if (utils.isOracle() && DatabaseManagement.isBlank(schemaPasswordArg)) {
                invalidArguments.append("Schema password is required for " + operationArg + ".\n");
            }
        } else if ("UPGRADE".equalsIgnoreCase(operationArg)) {
            if (DatabaseManagement.isBlank(installDirArg)) {
                invalidArguments.append("Install directory is required for " + operationArg + ".\n");
            }
            if (utils.isOracle() && DatabaseManagement.isBlank(backupDirArg)) {
                try {
                    utils.checkOracleDBADirectoryExists();
                }
                catch (SQLException e) {
                    invalidArguments.append("Backup directory " + backupDirArg + " is invalid for Oracle. Please verify that the directory exists within thr DBA_DIRECTORIES table and the DIRECTORY_PATH for the entry exists on the Database Server's filesystem.\n");
                }
            }
        } else if ("BACKUP".equalsIgnoreCase(operationArg)) {
            if (utils.isOracle() && DatabaseManagement.isBlank(backupDirArg)) {
                try {
                    utils.checkOracleDBADirectoryExists();
                }
                catch (SQLException e) {
                    invalidArguments.append("Backup directory " + backupDirArg + " is invalid for Oracle. Please verify that the directory exists within the DBA_DIRECTORIES table and the DIRECTORY_PATH for the entry exists on the Database Server's filesystem.\n");
                }
            }
        } else if ("REVERT".equalsIgnoreCase(operationArg)) {
            if (utils.isOracle() && DatabaseManagement.isBlank(backupDirArg) && DatabaseManagement.isBlank(revertVersionArg)) {
                invalidArguments.append("Revert version is required for reverting from backup on Oracle database (e.g 5.7.0.1)");
            }
        } else if (DatabaseManagement.isBlank(operationArg)) {
            invalidArguments.append("OPERATION is required.\n");
        } else if (!"PREREQ".equalsIgnoreCase(operationArg)) {
            invalidArguments.append("Invalid operation " + operationArg + "\n");
        }
        if (DatabaseManagement.isBlank(urlArg)) {
            invalidArguments.append("URL is required.\n");
        }
        if (DatabaseManagement.isBlank(dbUsernameArg)) {
            invalidArguments.append("Database Username is required.\n");
        }
        if (DatabaseManagement.isBlank(dbPasswordArg)) {
            invalidArguments.append("Database Password is required.\n");
        }
        if (DatabaseManagement.isBlank(logFilePathArg)) {
            invalidArguments.append("Log File path is required.\n");
        } else if (!Files.exists(Paths.get(logFilePathArg, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            invalidArguments.append("Log file " + logFilePathArg + " does not exist.\n");
        }
        if (invalidArguments.length() > 0) {
            DatabaseManagement.logError("Invalid arguments: \n" + invalidArguments);
            return false;
        }
        return true;
    }

    private static boolean isBlank(String check) {
        return check == null || check.isEmpty();
    }

    private static void install() {
        DatabaseManagement.logMessage("---Executing database schema install---");
        try {
            if (utils.isOracle()) {
                File installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "CreateFF.sql");
                utils.executeUpgradeScript(installScript);
                installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "FFOracle.sql");
                utils.executeUpgradeScript(installScript);
                installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "CreateFD.sql");
                utils.executeUpgradeScript(installScript);
                installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "GrantFF.sql");
                utils.executeUpgradeScript(installScript);
                installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "FDOracleObjects.sql");
                utils.executeUpgradeScript(installScript);
                installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "FDOracleGenerateProcedures.sql");
                utils.executeUpgradeScript(installScript);
                installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "GrantFD.sql");
                utils.executeUpgradeScript(installScript);
            } else if (utils.isPostgres()) {
                File installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "CreateSchemas.sql");
                utils.executeUpgradeScript(installScript);
                installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "FFPostgres.sql");
                utils.executeUpgradeScript(installScript);
                installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "FDPostgresObjects.sql");
                utils.executeUpgradeScript(installScript);
                installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "FDPostgresGenerateProcedures.sql");
                utils.executeUpgradeScript(installScript);
                installScript = new File(installDirArg + File.separator + "database" + File.separator + dbType + File.separator + "install" + File.separator + "scripts" + File.separator + "Grants.sql");
                utils.executeUpgradeScript(installScript);
            }
            utils.updateFDVersion(null);
        }
        catch (SQLNonTransientConnectionException installSqlConEx) {
            DatabaseManagement.handleException(installSqlConEx, 4);
        }
        catch (SQLException installSqlEx) {
            DatabaseManagement.handleException(installSqlEx, 5);
        }
        catch (IOException installIOEx) {
            DatabaseManagement.handleException(installIOEx, 6);
        }
        DatabaseManagement.logMessage("---Finished executing database schema install scripts---");
    }

    private static void upgrade() {
        String currentDBVersion = "";
        if (backupDirArg != null && !backupDirArg.isEmpty() && !utils.isPostgres()) {
            DatabaseManagement.logMessage("Taking database backup for upgrade");
            try {
                currentDBVersion = utils.getCurrentVersion();
                utils.backupDB("FD", currentDBVersion);
                utils.backupDB("FD_ADMIN", currentDBVersion);
                utils.backupDB("FF", currentDBVersion);
            }
            catch (SQLException backupSqlEx) {
                DatabaseManagement.handleException(backupSqlEx, 5);
            }
            catch (IOException backupIOEx) {
                DatabaseManagement.handleException(backupIOEx, 6);
            }
            catch (InterruptedException backupInterruptedEx) {
                DatabaseManagement.handleException(backupInterruptedEx, 9);
            }
            LocalDateTime backupCompleteTime = LocalDateTime.now();
            try {
                utils.logBackupInformation("FD", backupCompleteTime, currentDBVersion);
                utils.logBackupInformation("FD_ADMIN", backupCompleteTime, currentDBVersion);
                utils.logBackupInformation("FF", backupCompleteTime, currentDBVersion);
            }
            catch (IOException e1) {
                DatabaseManagement.handleException(e1, 12);
            }
            DatabaseManagement.logMessage("Database backup complete");
        }
        try {
            DatabaseManagement.logMessage("--- Executing database schema Upgrade ---");
            String currentVersion = utils.getCurrentVersion();
            List<String> filePaths = utils.getUpgradeScriptPaths(currentVersion);
            for (String filePath : filePaths) {
                File script = new File(filePath);
                utils.executeUpgradeScript(script);
                DatabaseManagement.logMessage("Executed " + script.getAbsolutePath());
            }
            DatabaseManagement.logMessage("--- Finished executing database schema upgrade scripts --- ");
        }
        catch (Exception upgradeEx) {
            upgradeEx.printStackTrace();
            if (upgradeEx instanceof SQLNonTransientConnectionException) {
                DatabaseManagement.handleException(upgradeEx, 4);
            }
            if (upgradeEx instanceof SQLException) {
                DatabaseManagement.handleException(upgradeEx, 5);
            }
            if (upgradeEx.getMessage() != null && upgradeEx.getMessage().contains("9.0.0.3")) {
                DatabaseManagement.handleException(upgradeEx, 14);
            }
            DatabaseManagement.handleException(upgradeEx, 6);
        }
    }

    private static void backup() {
        DatabaseManagement.logMessage("Taking database backup");
        String currentDBVersion = "";
        try {
            currentDBVersion = utils.getCurrentVersion();
            utils.backupDB("FD", currentDBVersion);
            utils.backupDB("FD_ADMIN", currentDBVersion);
            utils.backupDB("FF", currentDBVersion);
        }
        catch (SQLException backupSqlEx) {
            DatabaseManagement.handleException(backupSqlEx, 5);
        }
        catch (IOException backupIOEx) {
            DatabaseManagement.handleException(backupIOEx, 6);
        }
        catch (InterruptedException backupInterruptedEx) {
            DatabaseManagement.handleException(backupInterruptedEx, 9);
        }
        LocalDateTime backupCompleteTime = LocalDateTime.now();
        try {
            utils.logBackupInformation("FD", backupCompleteTime, currentDBVersion);
            utils.logBackupInformation("FD_ADMIN", backupCompleteTime, currentDBVersion);
            utils.logBackupInformation("FF", backupCompleteTime, currentDBVersion);
        }
        catch (IOException e1) {
            DatabaseManagement.handleException(e1, 12);
        }
        DatabaseManagement.logMessage("Database backup completed");
    }

    private static void revert() {
        DatabaseManagement.logMessage("Reverting from backup");
        try {
            utils.revertFromBackup("FD", revertVersionArg);
            utils.revertFromBackup("FD_ADMIN", revertVersionArg);
            utils.revertFromBackup("FF", revertVersionArg);
            DatabaseManagement.logMessage("Revert from backup completed");
        }
        catch (SQLException revertSqlEx) {
            DatabaseManagement.handleException(revertSqlEx, 5);
        }
        catch (IOException revertIOEx) {
            DatabaseManagement.handleException(revertIOEx, 6);
        }
        catch (InterruptedException revertInterrupedEx) {
            DatabaseManagement.handleException(revertInterrupedEx, 9);
        }
    }

    private static void prerequisite(boolean skipBackup, String prereqOp) {
        DatabaseManagement.logMessage("Validating prerequisites");
        boolean dbUserPermission = true;
        boolean dbDirectoryExists = true;
        try {
            utils.validateConnection();
            dbUserPermission = utils.checkDBUserPermissions();
            if (!dbUserPermission) {
                DatabaseManagement.logError("User " + utils.getUsername() + " does not have the required permissions.");
                throw new IllegalArgumentException("User " + utils.getUsername() + " does not have the required permissions.");
            }
            if (!(skipBackup || DatabaseManagement.isBlank(utils.getExportDirectory()) || (dbDirectoryExists = utils.checkOracleDBADirectoryExists()))) {
                DatabaseManagement.logError("DB Directory " + utils.getExportDirectory() + " does not exist in DBA_DIRECTORIES table.");
                throw new IllegalArgumentException("DB Directory " + utils.getExportDirectory() + " does not exist in DBA_DIRECTORIES table.");
            }
            if (DatabaseManagementUtils.TEN_DOT_O <= DatabaseManagementUtils.doubleVersionOf(utils.getFlexDeployVersionForLastMigrationFile()) && "UPGRADE".equals(prereqOp) && !utils.areMigrationsToNineDotORun()) {
                DatabaseManagement.handleException(new RuntimeException("You must upgrade to a 9.0.0.3+ version of FlexDeploy and let it run long enough to complete the migration process before installing FlexDeploy 10 or higher."), 14);
            }
        }
        catch (SQLException validateConPassEx) {
            DatabaseManagement.handleException(validateConPassEx, 11);
        }
        catch (IllegalArgumentException validateConURLEx) {
            if (!dbUserPermission || !dbDirectoryExists) {
                DatabaseManagement.handleException(validateConURLEx, 3);
            }
            DatabaseManagement.handleException(validateConURLEx, 10);
        }
        DatabaseManagement.logMessage("Validation of prerequisites completed");
    }

    public static void logError(String message) {
        System.err.println(DTF.format(LocalDateTime.now()) + " - " + message);
    }

    public static void logMessage(String message) {
        System.out.println(DTF.format(LocalDateTime.now()) + " - " + message);
    }

    public static void handleException(Exception e, int errorCode) {
        if (e != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String errorMessage = utils.hideSensitiveInformation(sw.toString());
            System.err.println(errorMessage);
        }
        System.exit(errorCode);
    }

    static {
        DTF = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss a");
        DatabaseManagement.initializeLogging();
    }
}

