#!/bin/bash

clear

# allow users of same group to write files as well.
umask 002

# set the base directory so script can be run from anywhere
# check to see if running from current directory, if so set an absolute path
BASE_DIR=$(CDPATH= cd -- "$(dirname -- "$0")" && pwd)
ERROR_CODES=""
WARN_CODES=""

FLEXDEPLOY_INSTALLER_HOME=${BASE_DIR}

# setup some variables for use
SCRIPTS_DIR=${BASE_DIR}/scripts
UTILS_DIR=${SCRIPTS_DIR}/utils
UTILS_SH=${UTILS_DIR}/utils.sh
PREREQS_SH=${UTILS_DIR}/prereqs.sh
LOGGING_SH=${UTILS_DIR}/logging.sh
CONSTANTS_SH=${UTILS_DIR}/constants.sh
INSTALL_SH=${UTILS_DIR}/install.sh
INSTALL_DOCKER_SH=${UTILS_DIR}/installDocker.sh
ERROR_MSG_DIR=${SCRIPTS_DIR}/errormsgs


function sourceIn
{
    echo "Sourcing in ${1}"
    RC=`. ${1} 2>&1 | wc -l`
    if [ ${RC} -ne 0 ]
    then
        . ${1}
        exit ${RC}
    else
        . ${1} || exitFatalErrorMessage 145 ${1}
    fi
}

# source in the utility functions
sourceIn "${UTILS_SH}"
sourceIn "${PREREQS_SH}"
sourceIn "${LOGGING_SH}"
sourceIn "${INSTALL_SH}"
sourceIn "${INSTALL_DOCKER_SH}"

# main script starts here

processArgs "${@}"

# source in the configuration file that will provide details on the installation/upgrade
sourceIn "${CONFIG_FILE}"

# source in constants
sourceIn "${CONSTANTS_SH}"

# need to get the log directory created earlier for logPoints to work for Docker
createDirectory "${LOG_DIRECTORY}" || exit 103

logPoint "Configuration file value for FLEXDEPLOY_HOME=${FLEXDEPLOY_HOME}"
logPoint "Configuration file value for ARTIFACT_REPOSITORY_DIRECTORY=${ARTIFACT_REPOSITORY_DIRECTORY}"
logPoint "Configuration file value for WORKING_DIRECTORY=${WORKING_DIRECTORY}"


echo "Installer version - ${BASE_DIR##*/} " >> "${LOG_FILE}"
echo "" >> ${LOG_FILE}
echo "Arguments - ${@}" >> "${LOG_FILE}"
echo "" >> ${LOG_FILE}

#Compare the config version and update as needed.
sourceIn "${UTILS_DIR}"/configConvert.sh

# source in setEnvOverride if it exists.
sourceSetEnvOverride

compareAndUpdateConfig


if [ "${DOCKER_INSTALL}" -eq 1 ]
then
    dockerPrereq
fi

#check that all required variables are provided and set defaults
#also sets the EXECUTION_STATE variable.
checkRequiredVariables

initialize

# download software if possible and/or unpack the zip file
# this also sets FLEXDEPLOY_VERSION.

prepareSoftware
if [ "${PREPARE_RC}" -ne 0 ]
then
    logPoint "Failed to extract the downloads. Unable to continue."
    exit "${PREPARE_RC}"
fi

# Check if influx is needed using FLEXDEPLOY_VERSION set in prepareSoftware above
isInfluxDBNeeded

# setupBackupVars uses FLEXDEPLOY_VERSION set in prepareSoftware above
setupBackupVars

# stopFlexDeploy will only stop if not PREREQ_MODE and no DOCKER_INSTALL
stopFlexDeploy

# setup all database download files, not the database itself
# also prepares influx database if it is needed.
manageDatabaseDownloads
# This variable is used in the prereqs to fail out at the end of them.
DOWNLOADS_FAILED=$?

# check to see if backup is needed
backupCurrentInstallation

# execute all prerequisites
prerequisites

# perform the install/upgrade when out of prereq mode
if [ "${PREREQ_MODE}" -eq 0 ]
then

    if [ "${DOCKER_INSTALL}" -eq 0 ]
    then
        if [ "${EXECUTION_STATE}" -eq "${UPGRADE}" ]
        then
            logPoint "Starting UPGRADE"
        else
            logPoint "Starting INSTALL"
        fi
        
        installFlexDeploy

        if [ "${EXECUTION_STATE}" -eq "${UPGRADE}" ]
        then
            logPoint "Completed UPGRADE"
        else
            logPoint "Completed INSTALL"
        fi

        startFlexDeploy
    else
        installFlexDeployDocker
    fi
fi

