#!/bin/bash
# This version should match the flexdeployinstaller_config.txt file.
TEMPLATE_CONFIG_VERSION=4.0

# function compareAndUpdateConfig
#
# parameters
# none
#
# return
# none
#
# compares the version of the current config file with the one above.
# if the versions differ, it updates, and if it is a major change, then it will stop the process for review.
function compareAndUpdateConfig
{
    OLD_CONFIG_VERSION=$(grep TEMPLATE_CONFIG_VERSION "${CONFIG_FILE}" | cut -d= -f2)
    OLD_MAJOR_CONFIG_VERSION=$(echo "${OLD_CONFIG_VERSION}"| cut -d. -f1)
    OLD_MINOR_CONFIG_VERSION=$(echo "${OLD_CONFIG_VERSION}"| cut -d. -f2)
    NEW_MAJOR_CONFIG_VERSION=$(echo "${TEMPLATE_CONFIG_VERSION}"| cut -d. -f1)
    NEW_MINOR_CONFIG_VERSION=$(echo "${TEMPLATE_CONFIG_VERSION}"| cut -d. -f2)
    if [ "${NEW_MAJOR_CONFIG_VERSION}" != "${OLD_MAJOR_CONFIG_VERSION}" ] || [ "${NEW_MINOR_CONFIG_VERSION}" != "${OLD_MINOR_CONFIG_VERSION}" ]
    then
        if [ "${NEW_MAJOR_CONFIG_VERSION}" -lt "${OLD_MAJOR_CONFIG_VERSION}" ] || { [ "${NEW_MAJOR_CONFIG_VERSION}" -eq "${OLD_MAJOR_CONFIG_VERSION}" ] && [ "${NEW_MINOR_CONFIG_VERSION}" -lt "${OLD_MINOR_CONFIG_VERSION}" ]; }
        then
            generateFatalErrorMessage 149 "${CONFIG_FILE}" "${FLEXDEPLOY_INSTALLER_HOME}" "https://flexagon.com/downloads/flexdeployinstaller"
            exit 149
        fi
        cp "${CONFIG_FILE}" "${CONFIG_FILE}.bak"
        if [ ! -f "${FLEXDEPLOY_INSTALLER_HOME}/flexdeployinstaller_config.txt" ]
        then
            generateFatalErrorMessage 141 "${FLEXDEPLOY_INSTALLER_HOME}/flexdeployinstaller_config.txt" "${FLEXDEPLOY_INSTALLER_HOME}" "https://flexagon.com/downloads/flexdeployinstaller"
            exit 141
        fi
        cp "${FLEXDEPLOY_INSTALLER_HOME}/flexdeployinstaller_config.txt" "${CONFIG_FILE}"
        updateConfig
        if [ "${NEW_MAJOR_CONFIG_VERSION}" != "${OLD_MAJOR_CONFIG_VERSION}" ]
        then
            generateFatalErrorMessage 140 "${CONFIG_FILE}" "${CONFIG_FILE}.bak"
        else
            logPoint "As part of the new installer release, your config file has been updated. The changes were considered minor, so the process is not stopping."
        fi
    fi
}

# function updateConfigValue
#
# parameters
# $1 - the property name
#
# return
# none
#
# updates the existing config file to the new config version.
function updateConfigValue
{
    VALUE=`grep "^${1}" "${CONFIG_FILE}.bak" | cut -d= -f2-`
    ESCAPED_VALUE=$(printf '%s\n' "${VALUE}" | sed -e 's/[\/&]/\\&/g')
    sed -i "s|^${1}=.*|${1}=${ESCAPED_VALUE}|g" "${CONFIG_FILE}"
}


# function updateConfig
#
# parameters
# none
#
# return
# none
#
# updates the existing config file to the new template version.
# New properties should be added here and to the config txt file.
function updateConfig
{
# The template config version doesn't come from their file, so need to sed it separately.
sed -i "s|^TEMPLATE_CONFIG_VERSION=.*|TEMPLATE_CONFIG_VERSION=${TEMPLATE_CONFIG_VERSION}|g" "${CONFIG_FILE}"

updateConfigValue FLEXDEPLOY_HOME
updateConfigValue FLEXDEPLOY_JAVA_HOME
updateConfigValue WORKING_DIRECTORY
updateConfigValue ARTIFACT_REPOSITORY_DIRECTORY
updateConfigValue BACKUP_DATABASE_DIRECTORY
updateConfigValue FLEXDEPLOY_PORT
updateConfigValue MAINTAIN_EXISTING_CONTEXT_FILE
updateConfigValue MAINTAIN_EXISTING_SERVER_FILE
updateConfigValue INFLUXDB_PORT
updateConfigValue FLEXDEPLOY_DB_PASSWORD
updateConfigValue SYSTEM_DB_USER
updateConfigValue SYSTEM_DB_PASSWORD
updateConfigValue DATABASE_URL
updateConfigValue CONTAINER_NAME
updateConfigValue CONTAINER_TIMEZONE
updateConfigValue FLEXDEPLOY_DB_USER
}