#!/bin/bash 

# software download
LATEST_VERSION_URL=https://flexagon.com/downloads/completedistribution/Tomcat/current_version.php
FLEXDEPLOY_SOFTWARE_DOWNLOAD_URL=https://flexagon.com/downloads/completedistribution/Tomcat
FLEXDEPLOY_ALT_SOFTWARE_DOWNLOAD_URL=https://flexagon.com/downloads/completedistribution/Tomcat/Tomcat_Complete-${DESIRED_VERSION}.zip

# minimum file system sizes in MB
MIN_WORKING_DIRECTORY_SIZE=10000
MIN_ARTIFACT_REPO_DIRECTORY_SIZE=10000
MIN_UPGRADE_BACKUP_DIRECTORY_SIZE=1000
MIN_INFLUX_DB_DIRECTORY_SIZE=2000
MIN_BACKUP_DATABASE_DIRECTORY_SIZE=10000

# size factor adjustment if running a POV, all minimum file system sizes will be adjusted by this factor
DIRECTORY_SIZE_FACTOR=.5

# max time to wait before killing the tomcat server in seconds
MAX_TIME_TO_WAIT_FOR_STOP=30
STOP_WAIT_TIME=2

# for error message
WARN=0
EXIT=1

# for different modes
STANDARD=0
POV=1

# install state
INSTALL=0
UPGRADE=1
UPGRADE_FROM_WLS=2

INSTALLER_DOWNLOADS_DIRECTORY=${FLEXDEPLOY_INSTALLER_HOME}/../downloads
INSTALLER_DOWNLOADS_SOFTWARE_DIRECTORY=${INSTALLER_DOWNLOADS_DIRECTORY}/software
INSTALLER_DOWNLOADS_WALLETS_DIRECTORY=${INSTALLER_DOWNLOADS_DIRECTORY}/wallets
INSTALLER_DOWNLOADS_INFLUXDB_DIRECTORY=${INSTALLER_DOWNLOADS_DIRECTORY}/influxdb

INFLUX_DB_FILE_NAME=influxdb2-2.2.0-linux-amd64.tar.gz
INFLUX_DB_CLIENT_FILE_NAME=influxdb2-client-2.2.1-linux-amd64.tar.gz
INFLUX_DB_DOWNLOAD_URL=https://dl.influxdata.com/influxdb/releases/influxdb2-2.2.0-linux-amd64.tar.gz
INFLUX_CLIENT_DOWNLOAD_URL=https://dl.influxdata.com/influxdb/releases/influxdb2-client-2.2.1-linux-amd64.tar.gz

INFLUX_DB_FILE_NAME_10=influxdb2-2.7.12_linux_amd64.tar.gz
INFLUX_DB_DOWNLOAD_URL_10=https://dl.influxdata.com/influxdb/releases/v2.7.12/influxdb2-2.7.12_linux_amd64.tar.gz
INFLUX_DB_CLIENT_FILE_NAME_10=influxdb2-client-2.7.5-linux-amd64.tar.gz
INFLUX_CLIENT_DOWNLOAD_URL_10=https://dl.influxdata.com/influxdb/releases/influxdb2-client-2.7.5-linux-amd64.tar.gz

INFLUX_DB_DIRECTORY=${FLEXDEPLOY_HOME}/influxdb
INFLUX_DB_CONFIG_DIRECTORY=${INFLUX_DB_DIRECTORY}/config
INFLUX_DB_LOG_FILE=${INFLUX_DB_LOGS}/influxd.log
INFLUX_DB_VSM_DATA_DIRECTORY=${WORKING_DIRECTORY}/vsm

INSTALLER_TEMP_DIRECTORY=${FLEXDEPLOY_INSTALLER_HOME}/../temp
INSTALLER_TEMP_SOFTWARE_DIRECTORY=${INSTALLER_TEMP_DIRECTORY}/software
INSTALLER_TEMP_CONFIG_DIRECTORY=${INSTALLER_TEMP_DIRECTORY}/config
INSTALLER_TEMP_DRIVER_DIRECTORY=${INSTALLER_TEMP_DIRECTORY}/driver
INSTALLER_TEMP_INFLUXDB_DIRECTORY=${INSTALLER_TEMP_DIRECTORY}/influxdb
INSTALLER_TEMP_SOFTWARE_PLUGINS_DIRECTORY=${INSTALLER_TEMP_SOFTWARE_DIRECTORY}/application/plugins

METAINF=META-INF
METAINF_MANIFEST_MF=${METAINF}/MANIFEST.MF
TOMCAT_COMPLETE_ZIP_FILE_NAME=TomcatComplete.zip
TOMCAT_SERVER_XML=server.xml
TOMCAT_CONTEXT_XML=context.xml
CONTEXT_XML_ORACLE=context-oracle.xml
CONTEXT_XML_POSTGRES=context-postgresql.xml
APACHE_TOMCAT_FLEXDEPLOY=apache-tomcat-flexdeploy
APACHE_TOMCAT_FLEXDEPLOY_LIB=${APACHE_TOMCAT_FLEXDEPLOY}/lib
APACHE_TOMCAT_FLEXDEPLOY_LIBEXT=${APACHE_TOMCAT_FLEXDEPLOY}/libext
APACHE_TOMCAT_FLEXDEPLOY_CONF=${APACHE_TOMCAT_FLEXDEPLOY}/conf
APACHE_TOMCAT_FLEXDEPLOY_LOGS=${APACHE_TOMCAT_FLEXDEPLOY}/logs
APACHE_TOMCAT_FLEXDEPLOY_WEBAPPS=${APACHE_TOMCAT_FLEXDEPLOY}/webapps
APACHE_TOMCAT_FLEXDEPLOY_BIN=${APACHE_TOMCAT_FLEXDEPLOY}/bin
APACHE_TOMCAT_FLEXDEPLOY_WEBAPPS_FLEXDEPLOY_WAR=${APACHE_TOMCAT_FLEXDEPLOY_WEBAPPS}/flexdeploy.war
FLEXDEPLOY_DATABASE_WALLET_DIRECTORY=${FLEXDEPLOY_HOME}/.wallets
FLEXDEPLOY_SSO_DIRECTORY=${FLEXDEPLOY_HOME}/.sso

UPGRADE_BASE_DIRECTORY=${FLEXDEPLOY_HOME}/upgrade

LOG_DIRECTORY=${UPGRADE_BASE_DIRECTORY}/logs
LOG_FILE=${LOG_DIRECTORY}/log-$(date +"%y-%m-%d_%H-%M-%S").txt
LOG_DATA_FILE=${LOG_DIRECTORY}/logData.txt

SETENV_FILE_NAME=setenv.sh
SETENVOVERRIDE_FILE_NAME=setenvoverride.sh
FLEXDEPLOY_TOMCAT_BIN_DIRECTORY=${FLEXDEPLOY_HOME}/${APACHE_TOMCAT_FLEXDEPLOY_BIN}

if [ "X${FLEXDEPLOY_DB_USER}" = "X" ]
then
  FLEXDEPLOY_DB_USER=fd_admin
fi
# this classpath uses the unzipped ojdbc8.jar as the prerequisites are prior to any content being layed down so instead of laying it down too early, just use this for the connection test only
DB_UTIL_CLASSPATH=${FLEXDEPLOY_INSTALLER_HOME}/scripts/jars/DatabaseManagement.jar:${INSTALLER_TEMP_DRIVER_DIRECTORY}/ojdbc8-full/*

# influxDB constants
ULIMIT_DESCRIPTOR_MAX=16384

SKIP_PLUGIN_SIZE_CHECK=0
SKIP_ARTIFACT_SIZE_CHECK=0
LATEST_VERSION=0
